/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.MessageDigest;

public final class MD2
extends MessageDigest {
    private MD2State state = new MD2State();
    private static final byte[] INIT_BUF = new byte[16];
    private static final int[] S = new int[]{41, 46, 67, 201, 162, 216, 124, 1, 61, 54, 84, 161, 236, 240, 6, 19, 98, 167, 5, 243, 192, 199, 115, 140, 152, 147, 43, 217, 188, 76, 130, 202, 30, 155, 87, 60, 253, 212, 224, 22, 103, 66, 111, 24, 138, 23, 229, 18, 190, 78, 196, 214, 218, 158, 222, 73, 160, 251, 245, 142, 187, 47, 238, 122, 169, 104, 121, 145, 21, 178, 7, 63, 148, 194, 16, 137, 11, 34, 95, 33, 128, 127, 93, 154, 90, 144, 50, 39, 53, 62, 204, 231, 191, 247, 151, 3, 255, 25, 48, 179, 72, 165, 181, 209, 215, 94, 146, 42, 172, 86, 170, 198, 79, 184, 56, 210, 150, 164, 125, 182, 118, 252, 107, 226, 156, 116, 4, 241, 69, 157, 112, 89, 100, 113, 135, 32, 134, 91, 207, 101, 230, 45, 168, 2, 27, 96, 37, 173, 174, 176, 185, 246, 28, 70, 97, 105, 52, 64, 126, 15, 85, 71, 163, 35, 221, 81, 175, 58, 195, 92, 249, 206, 186, 197, 234, 38, 44, 83, 13, 110, 133, 40, 132, 9, 211, 223, 205, 244, 65, 129, 77, 82, 106, 220, 55, 200, 108, 193, 171, 250, 36, 225, 123, 8, 12, 189, 177, 74, 120, 136, 149, 139, 227, 99, 232, 109, 233, 203, 213, 254, 59, 0, 29, 57, 242, 239, 183, 14, 102, 88, 208, 228, 166, 119, 114, 248, 235, 117, 75, 10, 49, 68, 80, 180, 143, 237, 31, 26, 219, 153, 141, 51, 159, 17, 131, 20};

    public MD2() {
        this.digestBits = new byte[16];
        this.digestValid = false;
    }

    @Override
    public void init() {
        if (this.state != null) {
            this.state.init();
        }
        this.digestValid = false;
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        return AlgID.md2;
    }

    @Override
    public int blockSize() {
        return 64;
    }

    @Override
    public int getDigestLength() {
        return 16;
    }

    @Override
    public void update(byte by) {
        int n = this.state.count;
        this.state.count = n + 1 & 0xF;
        this.state.buffer[n] = by;
        if (this.state.count == 0) {
            this.transform();
        }
        this.digestValid = false;
    }

    @Override
    public void computeCurrent() {
        MD2State mD2State = (MD2State)this.state.clone();
        int n = 16 - this.state.count;
        for (int i = 0; i < n; ++i) {
            this.update((byte)n);
        }
        byte[] byArray = new byte[16];
        System.arraycopy(this.state.checksum, 0, byArray, 0, 16);
        this.update(byArray);
        System.arraycopy(this.state.state, 0, this.digestBits, 0, 16);
        this.state = mD2State;
        this.digestValid = true;
    }

    @Override
    public String algName() {
        return "MD2";
    }

    private void transform() {
        int n;
        int n2;
        byte[] byArray = new byte[48];
        System.arraycopy(this.state.state, 0, byArray, 0, 16);
        System.arraycopy(this.state.buffer, 0, byArray, 16, 16);
        for (n2 = 0; n2 < 16; ++n2) {
            byArray[n2 + 32] = (byte)(this.state.state[n2] ^ this.state.buffer[n2]);
        }
        n2 = 0;
        for (n = 0; n < 18; ++n) {
            for (int i = 0; i < 48; ++i) {
                int n3 = i;
                byArray[n3] = (byte)(byArray[n3] ^ S[n2]);
                n2 = byArray[i] & 0xFF;
            }
            n2 = n2 + n & 0xFF;
        }
        System.arraycopy(byArray, 0, this.state.state, 0, 16);
        n2 = this.state.checksum[15] & 0xFF;
        for (n = 0; n < 16; ++n) {
            int n4 = n;
            this.state.checksum[n4] = (byte)(this.state.checksum[n4] ^ S[this.state.buffer[n] & 0xFF ^ n2]);
            n2 = this.state.checksum[n] & 0xFF;
        }
    }

    @Override
    public Object clone() {
        MD2 mD2 = new MD2();
        mD2.state = (MD2State)this.state.clone();
        System.arraycopy(this.digestBits, 0, mD2.digestBits, 0, this.digestBits.length);
        mD2.digestValid = this.digestValid;
        return mD2;
    }

    @Override
    protected MessageDigest.MDState getState() {
        return this.state;
    }

    @Override
    protected void setState(MessageDigest.MDState mDState) {
        mDState.copyTo(this.state);
        this.digestValid = false;
    }

    final class MD2State
    extends MessageDigest.MDState {
        byte[] state;
        byte[] checksum;
        byte[] buffer;
        int count;

        MD2State() {
            super(MD2.this);
            this.state = new byte[16];
            this.checksum = new byte[16];
            this.buffer = new byte[16];
        }

        @Override
        public void init() {
            System.arraycopy(INIT_BUF, 0, this.state, 0, this.state.length);
            System.arraycopy(INIT_BUF, 0, this.checksum, 0, this.checksum.length);
            System.arraycopy(INIT_BUF, 0, this.buffer, 0, this.buffer.length);
            this.count = 0;
        }

        @Override
        public Object clone() {
            MD2State mD2State = new MD2State();
            this.copyTo(mD2State);
            return mD2State;
        }

        @Override
        public void copyTo(MessageDigest.MDState mDState) {
            if (this.getClass() != mDState.getClass()) {
                throw new IllegalArgumentException("MD2State required");
            }
            MD2State mD2State = (MD2State)mDState;
            mD2State.count = this.count;
            System.arraycopy(this.state, 0, mD2State.state, 0, 16);
            System.arraycopy(this.checksum, 0, mD2State.checksum, 0, 16);
            System.arraycopy(this.buffer, 0, mD2State.buffer, 0, 16);
        }
    }
}

