/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.MessageDigest;
import com.phaos.utils.Utils;

public final class HMAC
extends MessageDigest {
    private AlgorithmIdentifier hashAlgID;
    private byte[] key;
    private byte[] ipad;
    private byte[] opad;
    private int keyOff;
    private int keyLen;
    private MessageDigest iHash;
    private MessageDigest oHash;
    private MessageDigest.MDState iState;
    private MessageDigest.MDState oState;

    public HMAC() {
    }

    public HMAC(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, int n, int n2) throws AlgorithmIdentifierException {
        this.key = byArray;
        this.keyOff = n;
        this.keyLen = n2;
        this.iHash = MessageDigest.getInstance(algorithmIdentifier);
        this.oHash = MessageDigest.getInstance(algorithmIdentifier);
        this.initialize();
    }

    public HMAC(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws AlgorithmIdentifierException {
        this(algorithmIdentifier, byArray, 0, byArray.length);
    }

    private HMAC(byte[] byArray, int n, int n2) {
        this.key = byArray;
        this.keyOff = n;
        this.keyLen = n2;
    }

    @Override
    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.getOID().equals(AlgID.hmacMD5.getOID())) {
            this.hashAlgID = AlgID.md5;
        } else if (algorithmIdentifier.getOID().equals(AlgID.hmacSHA.getOID())) {
            this.hashAlgID = AlgID.sha1;
        } else {
            throw new AlgorithmIdentifierException("Unrecognized algorithm identifier for HMAC: " + algorithmIdentifier.toString());
        }
        this.iHash = MessageDigest.getInstance(this.hashAlgID);
        this.oHash = MessageDigest.getInstance(this.hashAlgID);
        if (this.key == null) {
            this.key = new byte[0];
            this.keyOff = 0;
            this.keyLen = 0;
        } else {
            this.initialize();
        }
        this.algID = algorithmIdentifier;
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        return this.algID;
    }

    public void setKey(byte[] byArray, int n, int n2) {
        this.key = byArray;
        this.keyOff = n;
        this.keyLen = n2;
        this.initialize();
    }

    public void setKey(byte[] byArray) {
        this.setKey(byArray, 0, byArray.length);
    }

    @Override
    public void init() {
        this.iHash.setState(this.iState);
        this.oHash.setState(this.oState);
        this.digestValid = false;
    }

    private void initialize() {
        byte[] byArray;
        int n = this.iHash.blockSize();
        int n2 = this.oHash.getDigestLength();
        if (this.keyLen > n) {
            this.iHash.init();
            this.iHash.update(this.key, this.keyOff, this.keyLen);
            this.iHash.computeCurrent();
            byArray = this.iHash.digestBits;
            this.iHash.init();
        } else {
            byArray = new byte[this.keyLen];
            System.arraycopy(this.key, this.keyOff, byArray, 0, this.keyLen);
        }
        this.digestBits = new byte[n2];
        this.ipad = new byte[n];
        this.opad = new byte[n];
        Utils.setArray(this.ipad, (byte)54);
        Utils.setArray(this.opad, (byte)92);
        int n3 = 0;
        int n4 = 0;
        while (n3 < byArray.length) {
            int n5 = n3;
            this.ipad[n5] = (byte)(this.ipad[n5] ^ byArray[n4]);
            int n6 = n3++;
            this.opad[n6] = (byte)(this.opad[n6] ^ byArray[n4]);
            ++n4;
        }
        this.iHash.update(this.ipad);
        this.iHash.computeCurrent();
        this.oHash.update(this.opad);
        this.oHash.computeCurrent();
        this.iState = (MessageDigest.MDState)this.iHash.getState().clone();
        this.oState = (MessageDigest.MDState)this.oHash.getState().clone();
        this.digestValid = false;
    }

    @Override
    public void update(byte by) {
        this.iHash.update(by);
        this.digestValid = false;
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.iHash.update(byArray, n, n2);
        this.digestValid = false;
    }

    @Override
    public void computeCurrent() {
        MessageDigest messageDigest = (MessageDigest)this.iHash.clone();
        this.iHash.computeCurrent();
        this.oHash.update(this.iHash.digestBits);
        this.oHash.computeCurrent();
        System.arraycopy(this.oHash.digestBits, 0, this.digestBits, 0, this.digestBits.length);
        this.digestValid = true;
        this.iHash = messageDigest;
        this.oHash.setState(this.oState);
    }

    @Override
    public String algName() {
        return "HMAC-" + this.oHash.algName();
    }

    @Override
    public int blockSize() {
        return this.iHash.blockSize();
    }

    @Override
    public int getDigestLength() {
        return this.oHash.getDigestLength();
    }

    @Override
    public Object clone() {
        HMAC hMAC = new HMAC(this.key, this.keyOff, this.keyLen);
        hMAC.iHash = (MessageDigest)this.iHash.clone();
        hMAC.oHash = (MessageDigest)this.oHash.clone();
        hMAC.iState = (MessageDigest.MDState)this.iState.clone();
        hMAC.oState = (MessageDigest.MDState)this.oState.clone();
        hMAC.ipad = (byte[])this.ipad.clone();
        hMAC.opad = (byte[])this.opad.clone();
        hMAC.digestBits = (byte[])this.digestBits.clone();
        hMAC.digestValid = this.digestValid;
        return hMAC;
    }

    @Override
    protected MessageDigest.MDState getState() {
        return null;
    }

    @Override
    protected void setState(MessageDigest.MDState mDState) {
        throw new RuntimeException("setState not valid for HMAC class");
    }
}

