/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.SREntropySource;

public abstract class EntropySource {
    private static EntropySource defaultEntropySource;
    private static final Object obj;

    protected EntropySource() {
    }

    public abstract byte generateByte();

    public synchronized byte[] generateBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.generateByte();
        }
        return byArray;
    }

    public abstract void clear();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntropySource getDefault() {
        Object object = obj;
        synchronized (object) {
            if (defaultEntropySource == null) {
                defaultEntropySource = new SREntropySource();
            }
        }
        return defaultEntropySource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(EntropySource entropySource) {
        Object object = obj;
        synchronized (object) {
            defaultEntropySource = entropySource;
        }
    }

    static {
        obj = new Object();
    }
}

