/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.EntropySource;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.RandomBitsSource;

public abstract class DigestRandomBitsSource
extends RandomBitsSource {
    private byte[] pool;
    private byte[] current = new byte[0];
    private long count;
    private int index;
    private MessageDigest md;
    private boolean seeded = false;
    private static final int DEFAULT_SEED_SIZE = 20;

    protected DigestRandomBitsSource() {
    }

    protected synchronized void initialize(AlgorithmIdentifier algorithmIdentifier) {
        try {
            this.md = MessageDigest.getInstance(algorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException(algorithmIdentifierException.toString());
        }
        this.pool = new byte[this.md.blockSize()];
        this.seeded = false;
    }

    @Override
    public synchronized void seed(byte[] byArray) {
        this.md.init();
        this.md.update(this.pool);
        this.md.update(byArray);
        this.md.computeCurrent();
        this.pool = this.md.digestBits;
        this.index = 0;
        this.current = new byte[0];
        this.seeded = true;
    }

    public synchronized void seed(Object object) {
        this.md.init();
        this.md.update(this.pool);
        this.md.update(object.hashCode());
        this.md.update(object.toString());
        this.md.computeCurrent();
        this.pool = this.md.digestBits;
        this.index = 0;
        this.current = new byte[0];
        this.seeded = true;
    }

    @Override
    public synchronized void seed() {
        this.seed(EntropySource.getDefault());
    }

    @Override
    public synchronized void seed(EntropySource entropySource) {
        byte[] byArray = new byte[20];
        entropySource.generateBytes(byArray);
        this.seed(byArray);
    }

    @Override
    public synchronized byte randomByte() {
        if (!this.seeded) {
            throw new IllegalStateException("PRNG has not been seeded");
        }
        if (this.index == this.current.length) {
            this.md.init();
            this.md.update(this.pool);
            this.md.update(this.count++);
            this.md.computeCurrent();
            this.current = this.md.digestBits;
            this.index = 0;
        }
        return this.current[this.index++];
    }

    @Override
    public synchronized byte[] randomBytes(byte[] byArray) {
        int n;
        if (!this.seeded) {
            throw new IllegalStateException("PRNG has not been seeded");
        }
        System.arraycopy(this.current, this.index, byArray, 0, n);
        this.index += n;
        int n2 = byArray.length;
        for (n = Math.min(this.current.length - this.index, byArray.length); n < n2; n += this.current.length) {
            this.md.init();
            this.md.update(this.pool);
            this.md.update(this.count++);
            this.md.computeCurrent();
            this.current = this.md.digestBits;
            this.index = Math.min(this.current.length, byArray.length - n);
            System.arraycopy(this.md.digestBits, 0, byArray, n, this.index);
        }
        return byArray;
    }

    @Override
    public synchronized void clear() {
        if (this.pool != null) {
            for (int i = 0; i < this.pool.length; ++i) {
                this.pool[i] = 0;
            }
        }
        if (this.md != null) {
            this.md.init();
        }
        this.current = null;
        this.index = 0;
        this.count = 0;
        this.seeded = false;
    }
}

