/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.MessageDigest;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DigestOutputStream
extends FilterOutputStream {
    protected MessageDigest messageDigest;

    public DigestOutputStream(OutputStream outputStream, MessageDigest messageDigest) {
        super(outputStream);
        this.messageDigest = messageDigest;
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.messageDigest.update((byte)n);
        this.out.write(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            this.write(byArray[i]);
        }
    }

    public byte[] computeCurrent() {
        this.messageDigest.computeCurrent();
        return this.messageDigest.getDigestBits();
    }

    public MessageDigest getMessageDigest() {
        return this.messageDigest;
    }

    public void setMessageDigest(MessageDigest messageDigest) {
        this.messageDigest = messageDigest;
    }
}

