/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.MessageDigest;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DigestInputStream
extends FilterInputStream {
    protected MessageDigest messageDigest;

    public DigestInputStream(InputStream inputStream, MessageDigest messageDigest) {
        super(inputStream);
        this.messageDigest = messageDigest;
    }

    @Override
    public synchronized int read() throws IOException {
        int n = this.in.read();
        if (n != -1) {
            this.messageDigest.update((byte)n);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n4 = 0; n4 < n2 && (n3 = this.read()) != -1; ++n4) {
            byArray[n + n4] = (byte)n3;
        }
        return n4 != 0 ? n4 : -1;
    }

    public byte[] computeCurrent() {
        this.messageDigest.computeCurrent();
        return this.messageDigest.getDigestBits();
    }

    public MessageDigest getMessageDigest() {
        return this.messageDigest;
    }

    public void setMessageDigest(MessageDigest messageDigest) {
        this.messageDigest = messageDigest;
    }
}

