/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.math.Prime;
import com.phaos.utils.OIDManager;
import java.math.BigInteger;

public class DiffieHellman {
    protected BigInteger p;
    protected BigInteger g;
    protected BigInteger x;
    protected BigInteger gx;
    private static final BigInteger ONE = BigInteger.valueOf(1L);

    public DiffieHellman() {
    }

    public DiffieHellman(RandomBitsSource randomBitsSource, int n) throws IllegalArgumentException {
        this();
        this.initialize(randomBitsSource, n);
    }

    public DiffieHellman(BigInteger bigInteger, BigInteger bigInteger2, RandomBitsSource randomBitsSource) {
        this();
        this.initialize(bigInteger, bigInteger2, randomBitsSource);
    }

    public static DiffieHellman getInstance() throws AlgorithmIdentifierException {
        DiffieHellman diffieHellman;
        OIDManager oIDManager = OIDManager.getOIDManager();
        String string = oIDManager.getProperty(AlgID.dhKeyAgreement.getOID(), "cipher");
        if (string == null) {
            throw new AlgorithmIdentifierException("DiffieHellman algID not found");
        }
        try {
            Class<?> clazz = Class.forName(string);
            diffieHellman = (DiffieHellman)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + string + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + string + ":" + instantiationException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AlgorithmIdentifierException("Class " + string + " not found.");
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Class does not implement Cipher.");
        }
        return diffieHellman;
    }

    public static DiffieHellman getInstance(RandomBitsSource randomBitsSource, int n) throws IllegalArgumentException, AlgorithmIdentifierException {
        DiffieHellman diffieHellman = DiffieHellman.getInstance();
        diffieHellman.initialize(randomBitsSource, n);
        return diffieHellman;
    }

    public static DiffieHellman getInstance(BigInteger bigInteger, BigInteger bigInteger2, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException {
        DiffieHellman diffieHellman = DiffieHellman.getInstance();
        diffieHellman.initialize(bigInteger, bigInteger2, randomBitsSource);
        return diffieHellman;
    }

    public void initialize(RandomBitsSource randomBitsSource, int n) {
        this.generatePandG(randomBitsSource, n);
        this.generateValues(randomBitsSource);
    }

    public void initialize(BigInteger bigInteger, BigInteger bigInteger2, RandomBitsSource randomBitsSource) {
        this.p = bigInteger;
        this.g = bigInteger2;
        this.generateValues(randomBitsSource);
    }

    protected void generatePandG(RandomBitsSource randomBitsSource, int n) {
        do {
            BigInteger bigInteger = Prime.generatePrime(n, randomBitsSource);
            this.p = bigInteger.shiftLeft(1).add(ONE);
        } while (!this.p.isProbablePrime(100));
        this.g = BigInteger.valueOf(4L);
    }

    protected void generateValues(RandomBitsSource randomBitsSource) {
        while (true) {
            this.x = randomBitsSource.randomBigInteger(this.p.bitLength());
            if (this.x.compareTo(ONE) <= 0 && this.x.compareTo(this.p) >= 0) continue;
            this.gx = this.g.modPow(this.x, this.p);
            if (!this.gx.equals(ONE)) break;
        }
    }

    public BigInteger getPrime() {
        return this.p;
    }

    public BigInteger getGen() {
        return this.g;
    }

    public BigInteger myValue() {
        return this.gx;
    }

    public BigInteger getKey(BigInteger bigInteger) {
        return bigInteger.modPow(this.x, this.p);
    }

    public String toString() {
        return "p = " + this.p + ", g = " + this.g + ", x = " + this.x + ", gx = " + this.gx;
    }
}

