/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DSA;
import com.phaos.crypto.DSAParams;
import com.phaos.crypto.PublicKey;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;

public class DSAPublicKey
implements PublicKey,
ASN1Object,
Externalizable {
    private ASN1ObjectID algOID = DSA.dsaKeyOID;
    private DSAParams params;
    private BigInteger y;
    private ASN1Sequence contents;

    public DSAPublicKey() {
    }

    public DSAPublicKey(BigInteger bigInteger, DSAParams dSAParams) {
        this.y = bigInteger;
        this.params = dSAParams;
    }

    public DSAPublicKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public DSAPublicKey(byte[] byArray) throws IOException {
        this(new UnsyncByteArrayInputStream(byArray));
    }

    public DSAPublicKey(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(aSN1Sequence);
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        this.algOID = algorithmIdentifier.getOID();
        try {
            this.params = new DSAParams((ASN1Sequence)algorithmIdentifier.getParameters());
        }
        catch (IOException iOException) {
            throw new AlgorithmIdentifierException("Invalid DSA parameters.");
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Invalid DSA parameters.");
        }
        if (this.params == null) {
            throw new AlgorithmIdentifierException("DSA parameters missing.");
        }
        try {
            this.y = ((ASN1Integer)aSN1Object).getValue();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException("Contents invalid.");
        }
        aSN1Object = null;
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        return new AlgorithmIdentifier(this.algOID, this.params);
    }

    @Override
    public ASN1Object getContents() {
        return new ASN1Integer(this.y);
    }

    public ASN1ObjectID getKeyAlgOID() {
        return this.algOID;
    }

    public void setKeyAlgOID(ASN1ObjectID aSN1ObjectID) {
        this.algOID = aSN1ObjectID;
        this.contents = null;
    }

    public BigInteger getY() {
        return this.y;
    }

    public void setParams(DSAParams dSAParams) {
        this.params = dSAParams;
        this.contents = null;
    }

    public DSAParams getParams() {
        return this.params;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.contents = aSN1Sequence;
        try {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.elementAt(0);
            this.algOID = (ASN1ObjectID)aSN1Sequence2.elementAt(0);
            this.params = new DSAParams((ASN1Sequence)aSN1Sequence2.elementAt(1));
            ASN1BitString aSN1BitString = (ASN1BitString)aSN1Sequence.elementAt(1);
            this.y = ASN1Integer.inputValue(new UnsyncByteArrayInputStream(aSN1BitString.getValue()));
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    public ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        aSN1Sequence2.addElement(this.algOID);
        aSN1Sequence2.addElement(this.params);
        aSN1Sequence.addElement(aSN1Sequence2);
        aSN1Sequence.addElement(new ASN1BitString(Utils.toBytes(new ASN1Integer(this.y))));
        this.contents = aSN1Sequence;
        return aSN1Sequence;
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    @Override
    public byte[] getEncoded() {
        return Utils.toBytes(this);
    }

    @Override
    public int getBitLength() {
        if (this.params == null || this.params.getP() == null) {
            return 0;
        }
        return this.params.getP().bitLength();
    }

    public String toString() {
        return "y = " + this.y + ", params = {" + this.params + "}";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public void erase() {
        this.params = null;
        this.y = null;
        this.contents = null;
    }

    public void finalize() {
        this.erase();
    }

    @Override
    public Object clone() {
        DSAPublicKey dSAPublicKey = new DSAPublicKey();
        try {
            if (this.algOID != null) {
                dSAPublicKey.algOID = new ASN1ObjectID(Utils.toStream(this.algOID));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier to stream");
        }
        try {
            if (this.contents != null) {
                dSAPublicKey.contents = new ASN1Sequence(Utils.toStream(this.contents));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing key contents to stream");
        }
        try {
            if (this.params != null) {
                dSAPublicKey.params = new DSAParams(Utils.toStream(this.params));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing key DSA parameters to stream");
        }
        if (this.y != null) {
            dSAPublicKey.y = new BigInteger(this.y.toByteArray());
        }
        return dSAPublicKey;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

