/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class DSAParams
implements ASN1Object {
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;
    private byte[] seed;
    private int counter;
    private ASN1Sequence contents;

    public DSAParams() {
    }

    public DSAParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.p = bigInteger;
        this.q = bigInteger2;
        this.g = bigInteger3;
    }

    public DSAParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, byte[] byArray, int n) {
        this.p = bigInteger;
        this.q = bigInteger2;
        this.g = bigInteger3;
        this.seed = byArray;
        this.counter = n;
    }

    public DSAParams(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public DSAParams(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(aSN1Sequence);
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getG() {
        return this.g;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public int getCounter() {
        return this.counter;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.contents = aSN1Sequence;
        this.seed = null;
        try {
            this.p = ((ASN1Integer)aSN1Sequence.elementAt(0)).getValue();
            this.q = ((ASN1Integer)aSN1Sequence.elementAt(1)).getValue();
            this.g = ((ASN1Integer)aSN1Sequence.elementAt(2)).getValue();
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    public ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1Integer(this.p));
        aSN1Sequence.addElement(new ASN1Integer(this.q));
        aSN1Sequence.addElement(new ASN1Integer(this.g));
        this.contents = aSN1Sequence;
        return aSN1Sequence;
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    public String toString() {
        String string = "p = " + this.p + ", q = " + this.q + ", g = " + this.g;
        if (this.seed != null) {
            string = string + ",\nseed = " + Utils.toHexString(this.seed) + ", counter = " + this.counter;
        }
        return string;
    }
}

