/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Null;
import com.phaos.ASN1.ASN1Object;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DSAParams;
import com.phaos.crypto.DSAPrivateKey;
import com.phaos.crypto.DSAPublicKey;
import com.phaos.crypto.KeyPair;
import com.phaos.crypto.KeyPairGenerator;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.math.Prime;
import java.math.BigInteger;

public class DSAKeyPairGenerator
extends KeyPairGenerator {
    private DSAParams params;
    private AlgorithmIdentifier keyAlgID = AlgID.dsa;
    protected static final DSAParams params512 = new DSAParams(new BigInteger("12492156315694258518438122119006323799237110162140490763848993256055871214032560900677394116414321425392480831123940478668629071213037930849067708987561797"), new BigInteger("801990017674004996592495372795475144432167785027"), new BigInteger("2416161294771127319901315666703790942713833681450164303616597296690475377189730893345413708325615307310225313979735602963720957950755258782529372026391641"));
    protected static final DSAParams params768 = new DSAParams(new BigInteger("847198100946155561710307399779508173184457128156664161164146219421882327915073475669013220667420258484908654810304407590381994918086595198517076267445552648272351841808065130519547223061029101550004978958642084687668586641485517199"), new BigInteger("822710224377225222128937326700907925490005902807"), new BigInteger("774809834959489591459661268156343047964339133423157824672710776212233910908008334483365011387676918733816159938484546866731411707418746020651507449962477749235816006996558751009410902691182747947857176879528177046533903302222963959"));
    protected static final DSAParams params1024 = new DSAParams(new BigInteger("161756768501353294066626183132608614763109713347781303307809494201788145786086766632565723776515877527063255282137713643496150680763718237323344135572062802611728216674705098439563128548289535101877916048620151565468004419332049256669008213336599980552248203559391936808645815662034554991029528611306511263023"), new BigInteger("1079797971804353485335126622997120532804240961111"), new BigInteger("6530309311322880764774476607659473863630893214684539533075034340133395178524950590072708632400423957022360602591219745803762207151326446958725779643269855471917579006976398481954391601082152120248406291574749383155233113276975161340818874285909301731513558916061705580890998449766759627672339082497014715890"));

    @Override
    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.equals(AlgID.dsa) || algorithmIdentifier.equals(AlgID.dsaOld)) {
            this.keyAlgID = algorithmIdentifier;
            ASN1Object aSN1Object = algorithmIdentifier.getParameters();
            if (aSN1Object != null && aSN1Object.getClass() != ASN1Null.class) {
                this.params = (DSAParams)aSN1Object;
            }
        } else {
            throw new AlgorithmIdentifierException("Unknown DSA key algorithm identifier");
        }
    }

    @Override
    public void initialize(int n, RandomBitsSource randomBitsSource) {
        this.initialize(DSAKeyPairGenerator.getParameters(n, randomBitsSource), randomBitsSource);
    }

    public void initialize(DSAParams dSAParams, RandomBitsSource randomBitsSource) {
        this.params = dSAParams;
        this.setRandomBitsSource(randomBitsSource);
    }

    @Override
    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2 = this.params.getP();
        BigInteger bigInteger3 = this.params.getQ();
        BigInteger bigInteger4 = this.params.getG();
        BigInteger bigInteger5 = BigInteger.valueOf(1L);
        int n = bigInteger3.bitLength();
        if (this.rbs == null) {
            this.rbs = RandomBitsSource.getDefault();
        }
        while ((bigInteger = this.rbs.randomBigInteger(n)).compareTo(bigInteger5) <= 0 || bigInteger.compareTo(bigInteger3) >= 0) {
        }
        BigInteger bigInteger6 = bigInteger4.modPow(bigInteger, bigInteger2);
        DSAPublicKey dSAPublicKey = new DSAPublicKey(bigInteger6, this.params);
        DSAPrivateKey dSAPrivateKey = new DSAPrivateKey(bigInteger, this.params);
        dSAPublicKey.setKeyAlgOID(this.keyAlgID.getOID());
        dSAPrivateKey.setKeyAlgOID(this.keyAlgID.getOID());
        return new KeyPair(dSAPublicKey, dSAPrivateKey);
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    public static DSAParams getParameters(int n, RandomBitsSource randomBitsSource) {
        if (n == 512) {
            return params512;
        }
        if (n == 768) {
            return params768;
        }
        if (n == 1024) {
            return params1024;
        }
        return DSAKeyPairGenerator.generateParameters(n, randomBitsSource);
    }

    public static DSAParams generateParameters(int n, RandomBitsSource randomBitsSource) {
        return DSAKeyPairGenerator.generateParameters(n, null, randomBitsSource);
    }

    public static DSAParams generateParameters(int n, byte[] byArray, RandomBitsSource randomBitsSource) {
        int n2;
        byte[] byArray2 = new byte[20];
        byte[] byArray3 = new byte[20];
        boolean bl = false;
        if (byArray != null && byArray.length == 20) {
            System.arraycopy(byArray, 0, byArray2, 0, 20);
        } else {
            bl = true;
        }
        int n3 = (n - 1) / 160;
        int n4 = (n - 1) % 160;
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = BigInteger.valueOf(1L);
        BigInteger bigInteger5 = bigInteger4.shiftLeft(n - 1);
        BigInteger bigInteger6 = bigInteger5.subtract(bigInteger4);
        byte[] byArray4 = new byte[20];
        byte[] byArray5 = new byte[(n3 + 1) * 20];
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(AlgID.sha_1);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException("SHA1 class not found. " + algorithmIdentifierException.toString());
        }
        while (true) {
            int n5;
            if (bl) {
                randomBitsSource.randomBytes(byArray2);
            } else {
                bl = true;
            }
            System.arraycopy(byArray2, 0, byArray3, 0, 20);
            messageDigest.init();
            messageDigest.update(byArray3);
            messageDigest.computeCurrent();
            System.arraycopy(messageDigest.digestBits, 0, byArray4, 0, 20);
            for (n5 = 19; n5 >= 0 && (byArray3[n5] = (byte)((byArray3[n5] & 0xFF) + 1)) == 0; --n5) {
            }
            messageDigest.init();
            messageDigest.update(byArray3);
            messageDigest.computeCurrent();
            for (n5 = 0; n5 < 20; ++n5) {
                int n6 = n5;
                byArray4[n6] = (byte)(byArray4[n6] ^ messageDigest.digestBits[n5]);
            }
            byArray4[0] = (byte)(byArray4[0] | 0x80);
            byArray4[19] = (byte)(byArray4[19] | 1);
            bigInteger2 = new BigInteger(1, byArray4);
            if (!Prime.isProbablePrime(bigInteger2, 100, randomBitsSource)) continue;
            for (n2 = 0; n2 < 4096; ++n2) {
                for (int i = byArray5.length - 20; i >= 0; i -= 20) {
                    for (n5 = 19; n5 >= 0 && (byArray3[n5] = (byte)((byArray3[n5] & 0xFF) + 1)) == 0; --n5) {
                    }
                    messageDigest.init();
                    messageDigest.update(byArray3);
                    messageDigest.computeCurrent();
                    System.arraycopy(messageDigest.digestBits, 0, byArray5, i, 20);
                }
                BigInteger bigInteger7 = new BigInteger(1, byArray5).and(bigInteger6).add(bigInteger5);
                bigInteger = bigInteger7.subtract(bigInteger7.mod(bigInteger2.shiftLeft(1))).add(bigInteger4);
                if (bigInteger.compareTo(bigInteger5) >= 0 && Prime.isProbablePrime(bigInteger, 100, randomBitsSource)) break;
                bigInteger = null;
            }
            if (bigInteger != null) break;
        }
        BigInteger bigInteger8 = bigInteger.subtract(bigInteger4);
        BigInteger bigInteger9 = bigInteger8.divide(bigInteger2);
        BigInteger bigInteger10 = BigInteger.valueOf(2L);
        int n7 = bigInteger.bitLength();
        while ((bigInteger3 = bigInteger10.modPow(bigInteger9, bigInteger)).compareTo(bigInteger4) == 0) {
            bigInteger10 = bigInteger10.add(bigInteger4);
        }
        return new DSAParams(bigInteger, bigInteger2, bigInteger3, byArray2, n2);
    }
}

