/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DHKey;
import com.phaos.crypto.DHParams;
import com.phaos.crypto.PrivateKey;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.Utils;
import com.phaos.utils.VersionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class DHPrivateKey
extends DHKey
implements PrivateKey {
    private static final ASN1ObjectID algOID = AlgID.dh.getOID();
    private BigInteger x;
    private ASN1Sequence pki;

    public DHPrivateKey() {
    }

    public DHPrivateKey(BigInteger bigInteger, DHParams dHParams) {
        super(dHParams);
        this.x = bigInteger;
    }

    public DHPrivateKey(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public DHPrivateKey(File file) throws IOException {
        this(new FileInputStream(file));
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        if (!algOID.equals(algorithmIdentifier.getOID())) {
            throw new AlgorithmIdentifierException("Wrong algorithm identifier for Diffier-Hellman key");
        }
        try {
            ASN1Object aSN1Object2 = algorithmIdentifier.getParameters();
            if (aSN1Object2 != null) {
                this.params = aSN1Object2 instanceof DHParams ? (DHParams)aSN1Object2 : new DHParams(Utils.toStream((ASN1Sequence)aSN1Object2));
            }
        }
        catch (IOException iOException) {
            throw new AlgorithmIdentifierException("Invalid DH parameters.");
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Invalid DH parameters.");
        }
        try {
            this.x = ((ASN1Integer)aSN1Object).getValue();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException("Contents invalid.");
        }
        this.pki = null;
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        return new AlgorithmIdentifier(algOID, this.params);
    }

    @Override
    public ASN1Object getContents() {
        return new ASN1Integer(this.x);
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public void erase() {
        this.params = null;
        this.x = null;
    }

    @Override
    public Object clone() {
        DHPrivateKey dHPrivateKey = new DHPrivateKey();
        try {
            if (this.pki != null) {
                dHPrivateKey.pki = new ASN1Sequence(Utils.toStream(this.pki));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing key contents to stream");
        }
        try {
            if (this.params != null) {
                dHPrivateKey.params = new DHParams(Utils.toStream(this.params));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing key DH parameters to stream");
        }
        if (this.x != null) {
            dHPrivateKey.x = new BigInteger(this.x.toByteArray());
        }
        return dHPrivateKey;
    }

    @Override
    public void setParams(DHParams dHParams) {
        if (dHParams.getP() == null || dHParams.getQ() == null || dHParams.getG() == null) {
            throw new IllegalArgumentException("Missing P or Q or G in the params");
        }
        this.params = dHParams;
        this.pki = null;
    }

    public BigInteger getX() {
        return this.x;
    }

    public String toString() {
        return "params = {" + this.params + "}, x = " + this.x + "}";
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        try {
            ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.elementAt(0);
            if (!aSN1Integer.equals(0)) {
                throw new VersionException(aSN1Integer.getValue(), 0);
            }
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(1));
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(((ASN1OctetString)aSN1Sequence.elementAt(2)).getValue());
            this.initialize(algorithmIdentifier, aSN1Object);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new InvalidInputException(algorithmIdentifierException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException.toString());
        }
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.pki == null) {
            this.pki = CryptoUtils.privateKeyInfo(this);
        }
        return this.pki;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1Sequence().length();
    }
}

