/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DHParams;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.utils.Utils;
import java.math.BigInteger;

public class DHParameterGenerator {
    private int L;
    private int m;
    private RandomBitsSource rbs;
    private static final BigInteger zero = BigInteger.valueOf(0L);
    private static final BigInteger one = BigInteger.valueOf(1L);
    boolean initialized = false;

    public void initialize(int n, int n2) {
        this.initialize(n, n2, RandomBitsSource.getDefault());
    }

    public void initialize(int n, int n2, RandomBitsSource randomBitsSource) {
        if (n % 256 != 0 || n < 1024) {
            throw new IllegalArgumentException("L=" + n + " is not a mutiple of 256 of a factor not less than 4");
        }
        this.L = n;
        if (n2 < 160) {
            throw new IllegalArgumentException("m=" + n2 + " is smaller than 160");
        }
        this.m = n2;
        this.rbs = randomBitsSource;
        this.initialized = true;
    }

    public String getAlgorithm() {
        return "Diffie-Hellman";
    }

    public DHParams generateParameters() {
        BigInteger bigInteger;
        if (!this.initialized) {
            throw new IllegalStateException("The generator is not initialized.");
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(AlgID.sha_1);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException("SHA1 class not found. " + algorithmIdentifierException.toString());
        }
        BigInteger bigInteger2 = null;
        byte[] byArray = new byte[this.m / 8 + 1];
        while (!(bigInteger2 = DHParameterGenerator.generateQ(byArray = this.rbs.randomBytes(byArray), this.m, messageDigest)).isProbablePrime(100)) {
        }
        BigInteger bigInteger3 = null;
        int n = 0;
        int n2 = this.L / 1024;
        if (n2 * 1024 < this.L) {
            ++n2;
        }
        while (!((bigInteger3 = DHParameterGenerator.generateP(bigInteger2, byArray, n, this.L, this.m, messageDigest)).compareTo(one.shiftLeft(this.L - 1)) > 0 && bigInteger3.isProbablePrime(100) || ++n >= 4096 * n2)) {
        }
        if (n >= 4096 * n2) {
            throw new RuntimeException("Failed in generating primes");
        }
        BigInteger bigInteger4 = bigInteger3.subtract(one).divide(bigInteger2);
        BigInteger bigInteger5 = BigInteger.valueOf(2L);
        while (true) {
            if ((bigInteger = bigInteger5.modPow(bigInteger4, bigInteger3)).compareTo(one) > 0) break;
            bigInteger5 = bigInteger5.add(one);
        }
        bigInteger5 = bigInteger;
        return new DHParams(bigInteger3, bigInteger5, bigInteger2, bigInteger4, byArray, n);
    }

    static BigInteger generateQ(byte[] byArray, int n, MessageDigest messageDigest) {
        int n2 = n / 160;
        if (n2 * 160 < n) {
            ++n2;
        }
        BigInteger bigInteger = new BigInteger(byArray);
        BigInteger bigInteger2 = zero;
        for (int i = 0; i < n2; ++i) {
            messageDigest.init();
            messageDigest.update(bigInteger.add(BigInteger.valueOf(i)).toByteArray());
            messageDigest.computeCurrent();
            byte[] byArray2 = messageDigest.getDigestBits();
            messageDigest.init();
            messageDigest.update(bigInteger.add(BigInteger.valueOf(i + n2)).toByteArray());
            messageDigest.computeCurrent();
            byArray2 = Utils.xor(byArray2, messageDigest.getDigestBits());
            bigInteger2 = bigInteger2.add(new BigInteger(1, byArray2).shiftLeft(160 * i));
        }
        if (!(bigInteger2 = bigInteger2.mod(one.shiftLeft(n))).testBit(0)) {
            bigInteger2 = bigInteger2.flipBit(0);
        }
        if (!bigInteger2.testBit(n - 1)) {
            bigInteger2 = bigInteger2.flipBit(n - 1);
        }
        return bigInteger2;
    }

    static BigInteger generateP(BigInteger bigInteger, byte[] byArray, int n, int n2, int n3, MessageDigest messageDigest) {
        int n4 = n3 / 160;
        int n5 = n2 / 160;
        if (n4 * 160 < n3) {
            ++n4;
        }
        if (n5 * 160 < n2) {
            ++n5;
        }
        BigInteger bigInteger2 = new BigInteger(byArray).add(BigInteger.valueOf(2 * n4)).add(BigInteger.valueOf(n5 * n));
        BigInteger bigInteger3 = zero;
        for (int i = 0; i < n5; ++i) {
            messageDigest.init();
            messageDigest.update(bigInteger2.add(BigInteger.valueOf(i)).toByteArray());
            messageDigest.computeCurrent();
            bigInteger3 = bigInteger3.add(new BigInteger(1, messageDigest.getDigestBits()).shiftLeft(160 * i));
        }
        if (!(bigInteger3 = bigInteger3.mod(one.shiftLeft(n2))).testBit(n2 - 1)) {
            bigInteger3 = bigInteger3.flipBit(n2 - 1);
        }
        bigInteger3 = bigInteger3.subtract(bigInteger3.mod(bigInteger.shiftLeft(1))).add(one);
        return bigInteger3;
    }
}

