/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Null;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DHParameterGenerator;
import com.phaos.crypto.DHParams;
import com.phaos.crypto.DHPrivateKey;
import com.phaos.crypto.DHPublicKey;
import com.phaos.crypto.KeyPair;
import com.phaos.crypto.KeyPairGenerator;
import com.phaos.crypto.RandomBitsSource;
import java.math.BigInteger;

public class DHKeyPairGenerator
extends KeyPairGenerator {
    private static final ASN1ObjectID algOID = AlgID.dh.getOID();
    private DHParams params;
    private boolean initialized = false;

    public void initialize(DHParams dHParams, RandomBitsSource randomBitsSource) {
        this.params = dHParams;
        this.setRandomBitsSource(randomBitsSource);
        this.initialized = true;
    }

    public void initialize(int n, int n2, RandomBitsSource randomBitsSource) {
        DHParameterGenerator dHParameterGenerator = new DHParameterGenerator();
        dHParameterGenerator.initialize(n, n2, randomBitsSource);
        this.initialize(dHParameterGenerator.generateParameters(), randomBitsSource);
    }

    @Override
    public void initialize(int n, RandomBitsSource randomBitsSource) {
        this.initialize(n, 160, randomBitsSource);
    }

    @Override
    public String getAlgorithm() {
        return "Diffie-Hellman";
    }

    @Override
    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (!algorithmIdentifier.getOID().equals(algOID)) {
            throw new AlgorithmIdentifierException("Unknown DH key algorithm identifier");
        }
        ASN1Object aSN1Object = algorithmIdentifier.getParameters();
        if (aSN1Object != null && aSN1Object.getClass() != ASN1Null.class) {
            this.params = (DHParams)aSN1Object;
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialized) {
            throw new IllegalStateException("The generator is not initialized.");
        }
        BigInteger bigInteger = this.params.getP();
        BigInteger bigInteger2 = this.params.getQ();
        BigInteger bigInteger3 = this.params.getG();
        BigInteger bigInteger4 = BigInteger.valueOf(1L);
        BigInteger bigInteger5 = null;
        while ((bigInteger5 = this.rbs.randomBigInteger(bigInteger2.bitLength())).compareTo(bigInteger4) <= 0 || bigInteger5.compareTo(bigInteger2) >= 0) {
        }
        BigInteger bigInteger6 = bigInteger3.modPow(bigInteger5, bigInteger);
        return new KeyPair(new DHPublicKey(bigInteger6, this.params), new DHPrivateKey(bigInteger5, this.params));
    }
}

