/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Object;
import com.phaos.crypto.DHParams;
import com.phaos.crypto.Key;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class DHKey
implements Key,
ASN1Object,
Externalizable {
    protected DHParams params;

    protected DHKey() {
    }

    protected DHKey(DHParams dHParams) {
        this.params = dHParams;
    }

    protected DHKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    @Override
    public String getAlgorithm() {
        return "Diffie-Hellman";
    }

    @Override
    public byte[] getEncoded() {
        return Utils.toBytes(this);
    }

    @Override
    public int getBitLength() {
        if (this.params == null || this.params.getP() == null) {
            return 0;
        }
        return this.params.getP().bitLength();
    }

    @Override
    public abstract Object clone();

    public DHParams getParams() {
        return this.params;
    }

    public abstract void setParams(DHParams var1);

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getEncoded());
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

