/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.Utils;

final class DESKey
extends SymmetricKey {
    private int numSubKeys;
    private static final byte[][] weakKeys = new byte[][]{Utils.fromHexString("0101010101010101"), Utils.fromHexString("1f1f1f1f0e0e0e0e"), Utils.fromHexString("e0e0e0e0f1f1f1f1"), Utils.fromHexString("fefefefefefefefe")};
    private static final byte[][] semiWeakKeys = new byte[][]{Utils.fromHexString("01fe01fe01fe01fe"), Utils.fromHexString("fe01fe01fe01fe01"), Utils.fromHexString("1fe01fe00ef10ef1"), Utils.fromHexString("e01fe01ff10ef10e"), Utils.fromHexString("01e001e001f101f1"), Utils.fromHexString("e001e001f101f101"), Utils.fromHexString("1ffe1ffe0efe0efe"), Utils.fromHexString("fe1ffe1ffe0efe0e"), Utils.fromHexString("011f011f010e010e"), Utils.fromHexString("1f011f010e010e01"), Utils.fromHexString("e0fee0fef1fef1fe"), Utils.fromHexString("fee0fee0fef1fef1")};
    private static final byte[][] possiblyWeakKeys = new byte[][]{Utils.fromHexString("1f1f01010e0e0101"), Utils.fromHexString("e00101e0f10101f1"), Utils.fromHexString("011f1f01010e0e01"), Utils.fromHexString("fe1f01e0fe0e01f1"), Utils.fromHexString("1f01011f0e01010e"), Utils.fromHexString("fe011fe0fe010ef1"), Utils.fromHexString("01011f1f01010e0e"), Utils.fromHexString("e01f1fe0f10e0ef1"), Utils.fromHexString("e0e00101f1f10101"), Utils.fromHexString("fe0101fefe0101fe"), Utils.fromHexString("fefe0101fefe0101"), Utils.fromHexString("e01f01fef10e01fe"), Utils.fromHexString("fee01f01fef10e01"), Utils.fromHexString("e0011ffef1010efe"), Utils.fromHexString("e0fe1f01f1fe0e01"), Utils.fromHexString("fe1f1ffefe0e0efe"), Utils.fromHexString("fee0011ffef1010e"), Utils.fromHexString("1ffe01e00efe01f1"), Utils.fromHexString("e0fe011ff1fe010e"), Utils.fromHexString("01fe1fe001fe0ef1"), Utils.fromHexString("e0e01f1ff1f10e0e"), Utils.fromHexString("1fe001fe0ef101fe"), Utils.fromHexString("fefe1f1ffefe0e0e"), Utils.fromHexString("01e01ffe01f10efe"), Utils.fromHexString("fe1fe001fe0ef101"), Utils.fromHexString("0101e0e00101f1f1"), Utils.fromHexString("e01ffe01f10efe01"), Utils.fromHexString("1f1fe0e00e0ef1f1"), Utils.fromHexString("fe01e01ffe01f10e"), Utils.fromHexString("1f0efee00e01fef1"), Utils.fromHexString("e001fe1ff101fe0e"), Utils.fromHexString("011ffee0010efef1"), Utils.fromHexString("01e0e00101f1f101"), Utils.fromHexString("1f01e0fe0e01f1fe"), Utils.fromHexString("1ffee0010efef001"), Utils.fromHexString("011fe0fe010ef1fe"), Utils.fromHexString("1fe0fe010ef1fe01"), Utils.fromHexString("0101fefe0101fefe"), Utils.fromHexString("01fefe0101fefe01"), Utils.fromHexString("1f1ffefe0e0efefe"), Utils.fromHexString("1fe0e01f0ef1f10e"), Utils.fromHexString("fefee0e0fefef1f1"), Utils.fromHexString("01fee01f01fef10e"), Utils.fromHexString("e0fefee0f1fefef1"), Utils.fromHexString("01e0fe1f01f1fe0e"), Utils.fromHexString("fee0e0fefef1f1fe"), Utils.fromHexString("1ffefe1f0efefe0e"), Utils.fromHexString("e0e0fefef1f1fefe")};

    public DESKey(byte[] byArray, AlgorithmIdentifier algorithmIdentifier) {
        super(byArray, algorithmIdentifier);
        ASN1ObjectID aSN1ObjectID = algorithmIdentifier.getOID();
        this.numSubKeys = aSN1ObjectID.equals(AlgID.DES_EDE3_CBC.getOID()) || aSN1ObjectID.equals(AlgID.DES_EDE3_ECB.getOID()) ? byArray.length / 8 : 1;
    }

    public boolean isWeak() {
        int n = weakKeys.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.numSubKeys; ++j) {
                if (!Utils.areEqual(weakKeys[i], 0, this.keyBytes, j * 8, 8)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSemiWeak() {
        int n = semiWeakKeys.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.numSubKeys; ++j) {
                if (!Utils.areEqual(semiWeakKeys[i], 0, this.keyBytes, j * 8, 8)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPossiblyWeak() {
        int n = possiblyWeakKeys.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.numSubKeys; ++j) {
                if (!Utils.areEqual(possiblyWeakKeys[i], 0, this.keyBytes, j * 8, 8)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkParity(int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("Invalid parity argument");
        }
        for (byte by : this.keyBytes) {
            int n2 = by >> 7 ^ by >> 6 ^ by >> 5 ^ by >> 4 ^ by >> 3 ^ by >> 2 ^ by >> 1 ^ by;
            if ((n2 & 1) == n) continue;
            return false;
        }
        return true;
    }

    public void setParity(int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("Invalid parity argument");
        }
        for (byte by : this.keyBytes) {
            int n2 = by >> 7 ^ by >> 6 ^ by >> 5 ^ by >> 4 ^ by >> 3 ^ by >> 2 ^ by >> 1;
            this.keyBytes[var4_2] = n == 1 ? (byte)((by | 1) ^ n2 & 1) : (byte)(by & 0xFE ^ n2 & 1);
        }
    }
}

