/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.Coder;
import com.phaos.crypto.CoderException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CoderInputStream
extends FilterInputStream {
    public static final int DECODE_MODE = 0;
    public static final int ENCODE_MODE = 1;
    protected int mode = 0;
    protected Coder coder;
    protected byte[] buf;
    protected int count;

    public CoderInputStream(InputStream inputStream, Coder coder) {
        super(inputStream);
        this.coder = coder;
        this.buf = new byte[this.coder.blockSize()];
        this.count = this.coder.blockSize();
    }

    public Coder getCoder() {
        return this.coder;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.count < this.coder.blockSize()) {
            return this.buf[this.count++] & 0xFF;
        }
        byte[] byArray = new byte[this.coder.blockSize()];
        int n = this.coder.blockSize();
        for (int i = 0; i < n; ++i) {
            int n2 = this.in.read();
            if (n2 == -1) {
                return -1;
            }
            byArray[i] = (byte)n2;
        }
        try {
            this.buf = this.mode == 1 ? this.coder.encodeOp(byArray) : this.coder.decodeOp(byArray);
            this.count = 0;
        }
        catch (CoderException coderException) {
            throw new IOException(coderException.toString());
        }
        return this.buf[this.count++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n4 = 0; n4 < n2 && (n3 = this.read()) != -1; ++n4) {
            byArray[n + n4] = (byte)n3;
        }
        return n4 != 0 ? n4 : -1;
    }

    @Override
    public synchronized int available() throws IOException {
        int n = this.coder.blockSize();
        return n - this.count + this.in.available() / n * n;
    }
}

