/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.Cipher;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Key;
import com.phaos.crypto.SymmetricKey;

public final class Arcfour
extends Cipher {
    private int[] state;
    private int x;
    private int y;

    public Arcfour() {
        this.cipherStateInit();
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, Key key) throws AlgorithmIdentifierException, InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("The key is not an instance of SymmetricKey");
        }
        if (key == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        if (!algorithmIdentifier.getOID().equals(AlgID.RC4.getOID())) {
            throw new AlgorithmIdentifierException("Unknown AlgorithmIdentifier for Arcfour");
        }
        super.setKey((SymmetricKey)key);
        this.cipherStateInit();
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
    }

    public void initialize(SymmetricKey symmetricKey) throws InvalidKeyException {
        if (symmetricKey == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        super.setKey(symmetricKey);
        this.cipherStateInit();
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
    }

    private void cipherStateInit() {
        if (this.state == null) {
            this.state = new int[256];
        }
        for (int i = 0; i < 256; ++i) {
            this.state[i] = i;
        }
        this.x = 0;
        this.y = 0;
    }

    private void setKeyMaterial(SymmetricKey symmetricKey) {
        byte[] byArray = symmetricKey.getBytes();
        int[] nArray = this.state;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < 256; ++i) {
            n2 = (byArray[n] & 0xFF) + nArray[i] + n2 & 0xFF;
            int n3 = nArray[i];
            nArray[i] = nArray[n2];
            nArray[n2] = n3;
            ++n;
            n %= byArray.length;
        }
    }

    @Override
    public byte[] decrypt(byte[] byArray, int n, int n2, boolean bl) throws CipherException {
        byte[] byArray2 = new byte[n2];
        this.decrypt(byArray, n, n2, byArray2, 0);
        return byArray2;
    }

    @Override
    public void decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CipherException {
        this.assertDecryption();
        int n4 = n + n2;
        int[] nArray = this.state;
        int n5 = n;
        int n6 = n3;
        while (n5 < n4) {
            int n7;
            ++this.x;
            this.x &= 0xFF;
            int n8 = nArray[this.x];
            this.y += n8;
            this.y &= 0xFF;
            nArray[this.x] = n7 = nArray[this.y];
            nArray[this.y] = n8;
            byArray2[n6] = (byte)(nArray[n8 + n7 & 0xFF] ^ byArray[n5]);
            ++n5;
            ++n6;
        }
    }

    @Override
    public byte[] encrypt(byte[] byArray, int n, int n2, boolean bl) throws CipherException {
        byte[] byArray2 = new byte[n2];
        this.encrypt(byArray, n, n2, byArray2, 0);
        return byArray2;
    }

    @Override
    public void encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CipherException {
        this.assertEncryption();
        int n4 = n + n2;
        int[] nArray = this.state;
        int n5 = n;
        int n6 = n3;
        while (n5 < n4) {
            int n7;
            ++this.x;
            this.x &= 0xFF;
            int n8 = nArray[this.x];
            this.y += n8;
            this.y &= 0xFF;
            nArray[this.x] = n7 = nArray[this.y];
            nArray[this.y] = n8;
            byArray2[n6] = (byte)(nArray[n8 + n7 & 0xFF] ^ byArray[n5]);
            ++n5;
            ++n6;
        }
    }

    @Override
    public void erase() {
        this.cipherStateInit();
        this.releaseOp();
        this.eraseKeys();
    }

    @Override
    public String algName() {
        return "Arcfour";
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        return (AlgorithmIdentifier)AlgID.RC4.clone();
    }

    @Override
    public final int getBlockSize() {
        return 1;
    }

    private byte performArcfourOperation(byte by) {
        int n;
        int[] nArray = this.state;
        ++this.x;
        this.x &= 0xFF;
        int n2 = nArray[this.x];
        this.y += n2;
        this.y &= 0xFF;
        nArray[this.x] = n = nArray[this.y];
        nArray[this.y] = n2;
        return (byte)(nArray[n2 + n & 0xFF] ^ by);
    }

    @Override
    public final int blockSize() {
        return 1;
    }

    @Override
    public void decryptOp(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        this.assertDecryption();
        byArray2[n2] = this.performArcfourOperation(byArray[n]);
    }

    @Override
    public void encryptOp(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        this.assertEncryption();
        byArray2[n2] = this.performArcfourOperation(byArray[n]);
    }

    @Override
    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (!algorithmIdentifier.getOID().equals(AlgID.RC4.getOID())) {
            throw new AlgorithmIdentifierException("Unknown AlgorithmIdentifier for Arcfour");
        }
        this.cipherStateInit();
        if (this.key != null) {
            this.setKeyMaterial((SymmetricKey)this.key);
        }
        this.releaseOp();
    }

    @Override
    public void setKey(SymmetricKey symmetricKey) throws InvalidKeyException {
        super.setKey(symmetricKey);
        this.cipherStateInit();
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
    }

    @Override
    public void setEncryptionKey(Key key) throws InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("Key must be an instance of a SymmetricKey to be used with the Arcfour cipher");
        }
        super.setEncryptionKey(key);
        this.cipherStateInit();
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
    }

    @Override
    public void setDecryptionKey(Key key) throws InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("Key must be an instance of a SymmetricKey to be used with the Arcfour cipher");
        }
        super.setDecryptionKey(key);
        this.cipherStateInit();
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
    }

    @Override
    public void setMode(int n) {
        super.setMode(n);
        this.cipherStateInit();
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
    }

    @Override
    public void setPadding(int n) {
        super.setPadding(n);
        this.cipherStateInit();
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
    }

    @Override
    public void setIV(byte[] byArray) throws CipherException {
        this.cipherStateInit();
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
    }
}

