/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.BlockCipher;
import com.phaos.crypto.CBCAlgorithmIdentifier;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Key;
import com.phaos.crypto.Padding;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.ObjectOutputStream;

public final class AES
extends BlockCipher {
    private AlgorithmIdentifier algID = null;
    private int nb;
    private int nk;
    private int nr;
    private int[] extEnKey;
    private int[] extDeKey;
    private byte[] enKeyBytes;
    private byte[] deKeyBytes;
    private int state0;
    private int state1;
    private int state2;
    private int state3;
    private int state4;
    private int state5;
    private int state6;
    private int state7;
    private int temp0;
    private int temp1;
    private int temp2;
    private int temp3;
    private int temp4;
    private int temp5;
    private int temp6;
    private int temp7;
    private int[] state;
    private int[] temp;
    private static int[][] mulTab = new int[256][8];
    private static final int[] RC = new int[30];
    private static final int[] ES = new int[256];
    private static final int[] DS = new int[256];
    private static final int[] ET_0 = new int[256];
    private static final int[] ET_1 = new int[256];
    private static final int[] ET_2 = new int[256];
    private static final int[] ET_3 = new int[256];
    private static final int[] DT_0 = new int[256];
    private static final int[] DT_1 = new int[256];
    private static final int[] DT_2 = new int[256];
    private static final int[] DT_3 = new int[256];
    private static final int[] DM_0 = new int[256];
    private static final int[] DM_1 = new int[256];
    private static final int[] DM_2 = new int[256];
    private static final int[] DM_3 = new int[256];
    private ObjectOutputStream traceOS = null;

    private static void initGeneric() {
        AES.initMulTab();
        AES.initRC();
        AES.initS();
        AES.initET();
        AES.initDT();
        AES.initDM();
    }

    private static void initMulTab() {
        for (int i = 0; i < 256; ++i) {
            AES.mulTab[i][0] = i;
            for (int j = 1; j < 8; ++j) {
                int n = mulTab[i][j - 1];
                AES.mulTab[i][j] = (n >> 7 & 1) == 0 ? n << 1 : (n << 1 ^ 0x1B) & 0xFF;
            }
        }
    }

    private static void initRC() {
        int n = 1;
        for (int i = 2; i <= 30; ++i) {
            AES.RC[i - 1] = Utils.bytesToWord((byte)n, 0, 0, 0);
            n = AES.mul(2, n & 0xFF);
        }
    }

    private static void initS() {
        for (int i = 0; i < 256; ++i) {
            int n = AES.inv(i);
            AES.ES[i] = (n & 1) * 31 ^ (n >> 1 & 1) * 62 ^ (n >> 2 & 1) * 124 ^ (n >> 3 & 1) * 248 ^ (n >> 4 & 1) * 241 ^ (n >> 5 & 1) * 227 ^ (n >> 6 & 1) * 199 ^ (n >> 7 & 1) * 143 ^ 0x63;
            AES.DS[AES.ES[i]] = i;
        }
    }

    private static void initET() {
        for (int i = 0; i < 256; ++i) {
            byte by = (byte)ES[i];
            byte by2 = (byte)AES.mul(ES[i], 2);
            byte by3 = (byte)AES.mul(ES[i], 3);
            AES.ET_0[i] = Utils.bytesToWord(by2, by, by, by3);
            AES.ET_1[i] = Utils.bytesToWord(by3, by2, by, by);
            AES.ET_2[i] = Utils.bytesToWord(by, by3, by2, by);
            AES.ET_3[i] = Utils.bytesToWord(by, by, by3, by2);
        }
    }

    private static void initDT() {
        for (int i = 0; i < 256; ++i) {
            byte by = (byte)AES.mul(DS[i], 14);
            byte by2 = (byte)AES.mul(DS[i], 9);
            byte by3 = (byte)AES.mul(DS[i], 13);
            byte by4 = (byte)AES.mul(DS[i], 11);
            AES.DT_0[i] = Utils.bytesToWord(by, by2, by3, by4);
            AES.DT_1[i] = Utils.bytesToWord(by4, by, by2, by3);
            AES.DT_2[i] = Utils.bytesToWord(by3, by4, by, by2);
            AES.DT_3[i] = Utils.bytesToWord(by2, by3, by4, by);
        }
    }

    private static void initDM() {
        for (int i = 0; i < 256; ++i) {
            byte by = (byte)AES.mul(i, 14);
            byte by2 = (byte)AES.mul(i, 9);
            byte by3 = (byte)AES.mul(i, 13);
            byte by4 = (byte)AES.mul(i, 11);
            AES.DM_0[i] = Utils.bytesToWord(by, by2, by3, by4);
            AES.DM_1[i] = Utils.bytesToWord(by4, by, by2, by3);
            AES.DM_2[i] = Utils.bytesToWord(by3, by4, by, by2);
            AES.DM_3[i] = Utils.bytesToWord(by2, by3, by4, by);
        }
    }

    public AES() {
        this.init(4, 4, 0);
    }

    public AES(int n) {
        if (n != 128 && n != 192 && n != 256) {
            throw new IllegalArgumentException("unknown keysize " + n);
        }
        this.init(4, n / 32, 0);
    }

    public AES(int n, int n2) {
        if (n != 128 && n != 192 && n != 256) {
            throw new IllegalArgumentException("unknown keysize " + n);
        }
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("unknown blockmode " + n2);
        }
        if (n2 == 0) {
            this.init(4, n / 32, 0);
        } else {
            this.init(4, n / 32, 1);
        }
    }

    public AES(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this.setAlgID(algorithmIdentifier);
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, Key key) throws AlgorithmIdentifierException, InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("The key is not an instance of SymmetricKey");
        }
        if (key == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        this.validateAlgID(algorithmIdentifier);
        this.validateKeySize(algorithmIdentifier, (SymmetricKey)key);
        this.rbs = null;
        try {
            this.setIV(null);
        }
        catch (CipherException cipherException) {
            throw new AlgorithmIdentifierException(cipherException.getMessage());
        }
        this.init(algorithmIdentifier);
        super.setKey((SymmetricKey)key);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.paddingID = Padding.NONE;
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        if (symmetricKey == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        if (iD == null) {
            throw new CipherException("The paddingID parameter cannot be null");
        }
        this.validateAlgID(algorithmIdentifier);
        this.validateKeySize(algorithmIdentifier, symmetricKey);
        this.rbs = null;
        this.setIV(null);
        this.init(algorithmIdentifier);
        super.setKey(symmetricKey);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.paddingID = iD;
    }

    private void validateAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.getOID().equals(AlgID.aes128_ECB.getOID()) || algorithmIdentifier.getOID().equals(AlgID.aes128_CBC.getOID()) || algorithmIdentifier.getOID().equals(AlgID.aes192_ECB.getOID()) || algorithmIdentifier.getOID().equals(AlgID.aes192_CBC.getOID()) || algorithmIdentifier.getOID().equals(AlgID.aes256_ECB.getOID()) || algorithmIdentifier.getOID().equals(AlgID.aes256_CBC.getOID())) {
            return;
        }
        throw new AlgorithmIdentifierException("Unknown (or unsupported) AES algorithm identifier " + algorithmIdentifier);
    }

    private void validateKeySize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey) throws InvalidKeyException {
        byte[] byArray = symmetricKey.getBytes();
        if (algorithmIdentifier.getOID().equals(AlgID.aes128_ECB.getOID()) && byArray.length == 16 || algorithmIdentifier.getOID().equals(AlgID.aes128_CBC.getOID()) && byArray.length == 16 || algorithmIdentifier.getOID().equals(AlgID.aes192_ECB.getOID()) && byArray.length == 24 || algorithmIdentifier.getOID().equals(AlgID.aes192_CBC.getOID()) && byArray.length == 24 || algorithmIdentifier.getOID().equals(AlgID.aes256_ECB.getOID()) && byArray.length == 32 || algorithmIdentifier.getOID().equals(AlgID.aes256_CBC.getOID()) && byArray.length == 32) {
            return;
        }
        throw new InvalidKeyException("Key size did not match size specified in the AlgorithmIdentifier");
    }

    private void init(int n, int n2) {
        if (n != 4 && n != 6 && n != 8) {
            throw new IllegalArgumentException("invalid Nb value " + n);
        }
        if (n2 != 4 && n2 != 6 && n2 != 8) {
            throw new IllegalArgumentException("invalid Nk value " + n2);
        }
        this.nb = n;
        this.blockSize = 4 * n;
        this.nk = n2;
        int n3 = n == 8 || n2 == 8 ? 14 : (this.nr = n == 4 && n2 == 4 ? 10 : 12);
        if (this.extEnKey != null) {
            Utils.setArray(this.extEnKey, 0);
        }
        if (this.extDeKey != null) {
            Utils.setArray(this.extDeKey, 0);
        }
        if (this.enKeyBytes != null) {
            Utils.setArray(this.enKeyBytes, (byte)0);
        }
        if (this.deKeyBytes != null) {
            Utils.setArray(this.deKeyBytes, (byte)0);
        }
        this.extEnKey = new int[(this.nr + 1) * n];
        this.extDeKey = new int[(this.nr + 1) * n];
        this.enKeyBytes = new byte[4 * n];
        this.deKeyBytes = new byte[4 * n];
    }

    private void init(int n) {
        if (n == 0) {
            this.mode = 0;
        } else if (n == 1) {
            this.mode = 1;
            this.initCBC(null);
        } else {
            throw new IllegalArgumentException("invalid cipher mode " + n + " for AES");
        }
    }

    private void init(int n, int n2, int n3) {
        this.init(n, n2);
        this.init(n3);
    }

    private void init(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.getOID().equals(AlgID.aes128_ECB.getOID())) {
            this.init(4, 4, 0);
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes192_ECB.getOID())) {
            this.init(4, 6, 0);
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes256_ECB.getOID())) {
            this.init(4, 8, 0);
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes128_CBC.getOID())) {
            this.init(4, 4);
            this.initCBC(CryptoUtils.getIV(algorithmIdentifier));
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes192_CBC.getOID())) {
            this.init(4, 6);
            this.initCBC(CryptoUtils.getIV(algorithmIdentifier));
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes256_CBC.getOID())) {
            this.init(4, 8);
            this.initCBC(CryptoUtils.getIV(algorithmIdentifier));
        } else {
            throw new AlgorithmIdentifierException("Unknown (or unsupported) AES algorithm identifier " + algorithmIdentifier);
        }
    }

    private void initCBC(byte[] byArray) {
        byte[] byArray2 = this.getIV();
        this.mode = 1;
        String string = "couldn't reset cipher IV";
        if (byArray != null) {
            string = "couldn't set IV provided with algID";
        } else if (byArray2 != null) {
            byArray = byArray2;
            string = "couldn't reset cipher IV";
        } else if (byArray2 == null) {
            byArray = this.getRBS().randomBytes(new byte[this.blockSize]);
            string = "couldn't randomize cipher IV";
        }
        try {
            this.setIV(byArray);
        }
        catch (CipherException cipherException) {
            throw new IllegalStateException(string + ":  " + cipherException.toString());
        }
        this.paddingID = Padding.PKCS5;
    }

    private void setKeyMaterial(SymmetricKey symmetricKey) throws InvalidKeyException {
        int n;
        byte[] byArray = symmetricKey.getBytes();
        int n2 = byArray.length * 8;
        int n3 = n2 == 128 ? 4 : (n2 == 192 ? 6 : (n = n2 == 256 ? 8 : -1));
        if (n < 0) {
            throw new InvalidKeyException("invalid keysize " + n2);
        }
        if (n != this.nk) {
            this.init(this.nb, n);
        }
        for (int i = 0; i < this.nb * (this.nr + 1); ++i) {
            if (i < this.nk) {
                this.extEnKey[i] = Utils.bytesToWord(byArray[4 * i], byArray[4 * i + 1], byArray[4 * i + 2], byArray[4 * i + 3]);
            } else {
                int n4 = this.extEnKey[i - 1];
                if (i % this.nk == 0) {
                    byte by = (byte)(n4 >> 24);
                    byte by2 = (byte)(n4 >> 16);
                    byte by3 = (byte)(n4 >> 8);
                    byte by4 = (byte)n4;
                    n4 = AES.subByte(by & 0xFF | (by4 & 0xFF) << 8 | (by3 & 0xFF) << 16 | (by2 & 0xFF) << 24) ^ RC[i / this.nk];
                } else if (this.nk > 6 && i % this.nk == 4) {
                    n4 = AES.subByte(n4);
                }
                this.extEnKey[i] = this.extEnKey[i - this.nk] ^ n4;
            }
            if (i < this.nb || i >= this.nb * this.nr) {
                this.extDeKey[i] = this.extEnKey[i];
                continue;
            }
            byte[] byArray2 = Utils.wordToBytes(this.extEnKey[i]);
            this.extDeKey[i] = DM_0[byArray2[0] & 0xFF] ^ DM_1[byArray2[1] & 0xFF] ^ DM_2[byArray2[2] & 0xFF] ^ DM_3[byArray2[3] & 0xFF];
        }
        Utils.wordsToBytes(this.extEnKey, this.nr * this.nb, this.enKeyBytes, 0, this.nb);
        Utils.wordsToBytes(this.extDeKey, 0, this.deKeyBytes, 0, this.nb);
    }

    @Override
    protected void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        if (this.nb != 4) {
            if (this.nb == 6) {
                throw new CipherException("not implemented for blocksize 192");
            }
            if (this.nb == 8) {
                throw new CipherException("not implemented for blocksize 256");
            }
            throw new CipherException("invalid blocksize " + this.nb);
        }
        this.decrypt128(byArray, n, byArray2, n2);
    }

    @Override
    protected void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        if (this.nb != 4) {
            if (this.nb == 6) {
                throw new CipherException("not implemented for blocksize 192");
            }
            if (this.nb == 8) {
                throw new CipherException("not implemented for blocksize 256");
            }
            throw new CipherException("invalid blocking parameter " + this.nb);
        }
        this.encrypt128(byArray, n, byArray2, n2);
    }

    @Override
    public String algName() {
        return "AES-" + this.nk * 32;
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        AlgorithmIdentifier algorithmIdentifier = this.nb == 4 ? (this.mode == 0 ? (this.nk == 4 ? AlgID.aes128_ECB : (this.nk == 6 ? AlgID.aes192_ECB : (this.nk == 8 ? AlgID.aes256_ECB : null))) : (this.mode == 1 ? (this.nk == 4 ? new CBCAlgorithmIdentifier(AlgID.aes128_CBC, this.getIV()) : (this.nk == 6 ? new CBCAlgorithmIdentifier(AlgID.aes192_CBC, this.getIV()) : (this.nk == 8 ? new CBCAlgorithmIdentifier(AlgID.aes256_CBC, this.getIV()) : null))) : null)) : null;
        return algorithmIdentifier;
    }

    public int getKeySize() {
        return 4 * this.nk;
    }

    @Override
    public void erase() {
        super.erase();
        this.nr = 0;
        this.nk = 0;
        this.nb = 0;
        this.blockSize = 0;
        Utils.setArray(this.extEnKey, 0);
        Utils.setArray(this.extDeKey, 0);
        Utils.setArray(this.enKeyBytes, (byte)0);
        Utils.setArray(this.deKeyBytes, (byte)0);
        this.state7 = 0;
        this.state6 = 0;
        this.state5 = 0;
        this.state4 = 0;
        this.state3 = 0;
        this.state2 = 0;
        this.state1 = 0;
        this.state0 = 0;
        this.temp7 = 0;
        this.temp6 = 0;
        this.temp5 = 0;
        this.temp4 = 0;
        this.temp3 = 0;
        this.temp2 = 0;
        this.temp1 = 0;
        this.temp0 = 0;
        if (this.traceOS != null) {
            this.traceOS = null;
        }
    }

    public String toString() {
        return this.algName();
    }

    @Override
    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        AlgorithmIdentifier algorithmIdentifier2 = this.getAlgID();
        if (algorithmIdentifier2.getOID().equals(algorithmIdentifier.getOID())) {
            byte[] byArray = CryptoUtils.getIV(algorithmIdentifier2);
            byte[] byArray2 = CryptoUtils.getIV(algorithmIdentifier);
            if (byArray == null && byArray2 == null) {
                if (algorithmIdentifier.getOID().equals(AlgID.aes128_CBC.getOID()) || algorithmIdentifier.getOID().equals(AlgID.aes192_CBC.getOID()) || algorithmIdentifier.getOID().equals(AlgID.aes256_CBC.getOID())) {
                    this.initCBC(null);
                }
            } else if (byArray == null || byArray2 == null) {
                this.init(algorithmIdentifier);
            } else if (!Utils.areEqual(byArray, byArray2)) {
                this.init(algorithmIdentifier);
            }
        } else {
            this.init(algorithmIdentifier);
        }
        this.releaseOp();
        this.resetLastCipherBlock();
    }

    @Override
    public void setKey(SymmetricKey symmetricKey) throws InvalidKeyException {
        super.setKey(symmetricKey);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.resetLastCipherBlock();
    }

    @Override
    public void setEncryptionKey(Key key) throws InvalidKeyException {
        super.setEncryptionKey(key);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.resetLastCipherBlock();
    }

    @Override
    public void setDecryptionKey(Key key) throws InvalidKeyException {
        super.setDecryptionKey(key);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.resetLastCipherBlock();
    }

    @Override
    public void setMode(int n) {
        if (n != this.getMode()) {
            if (n == 0 || n == 1) {
                this.init(n);
            } else {
                throw new IllegalArgumentException("The value, " + n + ", is not recognized " + "as a valid block mode");
            }
        }
        this.releaseOp();
        this.resetLastCipherBlock();
    }

    @Override
    public void encryptOp(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        this.assertEncryption();
        if (this.nb != 4) {
            if (this.nb == 6) {
                throw new CipherException("not implemented for blocksize 192");
            }
            if (this.nb == 8) {
                throw new CipherException("not implemented for blocksize 256");
            }
            throw new CipherException("invalid blocking parameter " + this.nb);
        }
        this.encrypt128(byArray, n, byArray2, n2);
    }

    private void encrypt128(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.state0 = Utils.bytesToWord(byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3]) ^ this.extEnKey[0];
        this.state1 = Utils.bytesToWord(byArray[n + 4], byArray[n + 5], byArray[n + 6], byArray[n + 7]) ^ this.extEnKey[1];
        this.state2 = Utils.bytesToWord(byArray[n + 8], byArray[n + 9], byArray[n + 10], byArray[n + 11]) ^ this.extEnKey[2];
        this.state3 = Utils.bytesToWord(byArray[n + 12], byArray[n + 13], byArray[n + 14], byArray[n + 15]) ^ this.extEnKey[3];
        for (int i = 1; i < this.nr; ++i) {
            int n3 = this.state0;
            int n4 = this.state1;
            int n5 = this.state2;
            int n6 = this.state3;
            this.state0 = ET_0[n3 >>> 24 & 0xFF] ^ ET_1[n4 >>> 16 & 0xFF] ^ ET_2[n5 >>> 8 & 0xFF] ^ ET_3[n6 & 0xFF] ^ this.extEnKey[i * 4];
            this.state1 = ET_0[n4 >>> 24 & 0xFF] ^ ET_1[n5 >>> 16 & 0xFF] ^ ET_2[n6 >>> 8 & 0xFF] ^ ET_3[n3 & 0xFF] ^ this.extEnKey[i * 4 + 1];
            this.state2 = ET_0[n5 >>> 24 & 0xFF] ^ ET_1[n6 >>> 16 & 0xFF] ^ ET_2[n3 >>> 8 & 0xFF] ^ ET_3[n4 & 0xFF] ^ this.extEnKey[i * 4 + 2];
            this.state3 = ET_0[n6 >>> 24 & 0xFF] ^ ET_1[n3 >>> 16 & 0xFF] ^ ET_2[n4 >>> 8 & 0xFF] ^ ET_3[n5 & 0xFF] ^ this.extEnKey[i * 4 + 3];
            if (this.traceOS == null) continue;
            try {
                this.traceOS.writeObject(new int[]{this.state0, this.state1, this.state2, this.state3});
                continue;
            }
            catch (IOException iOException) {
                throw new RuntimeException("iv trace mode broken:  " + iOException);
            }
        }
        byArray2[n2] = (byte)(ES[this.state0 >>> 24 & 0xFF] ^ this.enKeyBytes[0]);
        byArray2[n2 + 1] = (byte)(ES[this.state1 >>> 16 & 0xFF] ^ this.enKeyBytes[1]);
        byArray2[n2 + 2] = (byte)(ES[this.state2 >>> 8 & 0xFF] ^ this.enKeyBytes[2]);
        byArray2[n2 + 3] = (byte)(ES[this.state3 & 0xFF] ^ this.enKeyBytes[3]);
        byArray2[n2 + 4] = (byte)(ES[this.state1 >>> 24 & 0xFF] ^ this.enKeyBytes[4]);
        byArray2[n2 + 5] = (byte)(ES[this.state2 >>> 16 & 0xFF] ^ this.enKeyBytes[5]);
        byArray2[n2 + 6] = (byte)(ES[this.state3 >>> 8 & 0xFF] ^ this.enKeyBytes[6]);
        byArray2[n2 + 7] = (byte)(ES[this.state0 & 0xFF] ^ this.enKeyBytes[7]);
        byArray2[n2 + 8] = (byte)(ES[this.state2 >>> 24 & 0xFF] ^ this.enKeyBytes[8]);
        byArray2[n2 + 9] = (byte)(ES[this.state3 >>> 16 & 0xFF] ^ this.enKeyBytes[9]);
        byArray2[n2 + 10] = (byte)(ES[this.state0 >>> 8 & 0xFF] ^ this.enKeyBytes[10]);
        byArray2[n2 + 11] = (byte)(ES[this.state1 & 0xFF] ^ this.enKeyBytes[11]);
        byArray2[n2 + 12] = (byte)(ES[this.state3 >>> 24 & 0xFF] ^ this.enKeyBytes[12]);
        byArray2[n2 + 13] = (byte)(ES[this.state0 >>> 16 & 0xFF] ^ this.enKeyBytes[13]);
        byArray2[n2 + 14] = (byte)(ES[this.state1 >>> 8 & 0xFF] ^ this.enKeyBytes[14]);
        byArray2[n2 + 15] = (byte)(ES[this.state2 & 0xFF] ^ this.enKeyBytes[15]);
    }

    @Override
    public void decryptOp(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        this.assertDecryption();
        if (this.nb != 4) {
            if (this.nb == 6) {
                throw new CipherException("not implemented for blocksize 192");
            }
            if (this.nb == 8) {
                throw new CipherException("not implemented for blocksize 256");
            }
            throw new CipherException("invalid blocksize " + this.nb);
        }
        this.decrypt128(byArray, n, byArray2, n2);
    }

    private void decrypt128(byte[] byArray, int n, byte[] byArray2, int n2) {
        this.state0 = Utils.bytesToWord(byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3]) ^ this.extDeKey[4 * this.nr];
        this.state1 = Utils.bytesToWord(byArray[n + 4], byArray[n + 5], byArray[n + 6], byArray[n + 7]) ^ this.extDeKey[4 * this.nr + 1];
        this.state2 = Utils.bytesToWord(byArray[n + 8], byArray[n + 9], byArray[n + 10], byArray[n + 11]) ^ this.extDeKey[4 * this.nr + 2];
        this.state3 = Utils.bytesToWord(byArray[n + 12], byArray[n + 13], byArray[n + 14], byArray[n + 15]) ^ this.extDeKey[4 * this.nr + 3];
        for (int i = this.nr - 1; i > 0; --i) {
            this.temp0 = this.state0;
            this.temp1 = this.state1;
            this.temp2 = this.state2;
            this.temp3 = this.state3;
            this.state0 = DT_0[this.temp0 >>> 24 & 0xFF] ^ DT_1[this.temp3 >>> 16 & 0xFF] ^ DT_2[this.temp2 >>> 8 & 0xFF] ^ DT_3[this.temp1 & 0xFF] ^ this.extDeKey[i * 4];
            this.state1 = DT_0[this.temp1 >>> 24 & 0xFF] ^ DT_1[this.temp0 >>> 16 & 0xFF] ^ DT_2[this.temp3 >>> 8 & 0xFF] ^ DT_3[this.temp2 & 0xFF] ^ this.extDeKey[i * 4 + 1];
            this.state2 = DT_0[this.temp2 >>> 24 & 0xFF] ^ DT_1[this.temp1 >>> 16 & 0xFF] ^ DT_2[this.temp0 >>> 8 & 0xFF] ^ DT_3[this.temp3 & 0xFF] ^ this.extDeKey[i * 4 + 2];
            this.state3 = DT_0[this.temp3 >>> 24 & 0xFF] ^ DT_1[this.temp2 >>> 16 & 0xFF] ^ DT_2[this.temp1 >>> 8 & 0xFF] ^ DT_3[this.temp0 & 0xFF] ^ this.extDeKey[i * 4 + 3];
            if (this.traceOS == null) continue;
            try {
                this.traceOS.writeObject(new int[]{this.state0, this.state1, this.state2, this.state3});
                continue;
            }
            catch (IOException iOException) {
                throw new RuntimeException("iv trace mode broken:  " + iOException);
            }
        }
        byArray2[n2] = (byte)(DS[this.state0 >>> 24 & 0xFF] ^ this.deKeyBytes[0]);
        byArray2[n2 + 1] = (byte)(DS[this.state3 >>> 16 & 0xFF] ^ this.deKeyBytes[1]);
        byArray2[n2 + 2] = (byte)(DS[this.state2 >>> 8 & 0xFF] ^ this.deKeyBytes[2]);
        byArray2[n2 + 3] = (byte)(DS[this.state1 & 0xFF] ^ this.deKeyBytes[3]);
        byArray2[n2 + 4] = (byte)(DS[this.state1 >>> 24 & 0xFF] ^ this.deKeyBytes[4]);
        byArray2[n2 + 5] = (byte)(DS[this.state0 >>> 16 & 0xFF] ^ this.deKeyBytes[5]);
        byArray2[n2 + 6] = (byte)(DS[this.state3 >>> 8 & 0xFF] ^ this.deKeyBytes[6]);
        byArray2[n2 + 7] = (byte)(DS[this.state2 & 0xFF] ^ this.deKeyBytes[7]);
        byArray2[n2 + 8] = (byte)(DS[this.state2 >>> 24 & 0xFF] ^ this.deKeyBytes[8]);
        byArray2[n2 + 9] = (byte)(DS[this.state1 >>> 16 & 0xFF] ^ this.deKeyBytes[9]);
        byArray2[n2 + 10] = (byte)(DS[this.state0 >>> 8 & 0xFF] ^ this.deKeyBytes[10]);
        byArray2[n2 + 11] = (byte)(DS[this.state3 & 0xFF] ^ this.deKeyBytes[11]);
        byArray2[n2 + 12] = (byte)(DS[this.state3 >>> 24 & 0xFF] ^ this.deKeyBytes[12]);
        byArray2[n2 + 13] = (byte)(DS[this.state2 >>> 16 & 0xFF] ^ this.deKeyBytes[13]);
        byArray2[n2 + 14] = (byte)(DS[this.state1 >>> 8 & 0xFF] ^ this.deKeyBytes[14]);
        byArray2[n2 + 15] = (byte)(DS[this.state0 & 0xFF] ^ this.deKeyBytes[15]);
    }

    private static int mul(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < 8; ++i) {
            if ((n2 >> i & 1) == 0) continue;
            n3 ^= mulTab[n][i];
        }
        return n3;
    }

    private static int degP(int n) {
        int n2 = 0;
        while (n >> n2 != 0) {
            ++n2;
        }
        return n2 - 1;
    }

    private static int divP(int n, int n2) {
        int n3;
        int n4 = 0;
        while ((n3 = AES.degP(n) - AES.degP(n2)) >= 0) {
            n ^= n2 << n3;
            n4 ^= 1 << n3;
        }
        return n4;
    }

    private static int mulP(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i <= AES.degP(n2); ++i) {
            if ((n2 >> i & 1) == 0) continue;
            n3 ^= n << i;
        }
        return n3;
    }

    private static int inv(int n) {
        int n2 = 283;
        if (n == 0) {
            return 0;
        }
        int n3 = 1;
        int n4 = 0;
        while (n != 0) {
            int n5 = AES.divP(n2, n);
            int n6 = n2 ^ AES.mulP(n, n5);
            int n7 = n4 ^ AES.mulP(n3, n5);
            n2 = n;
            n = n6;
            n4 = n3;
            n3 = n7;
        }
        return n4;
    }

    private static int subByte(int n) {
        byte by = (byte)(n >> 24);
        byte by2 = (byte)(n >> 16);
        byte by3 = (byte)(n >> 8);
        byte by4 = (byte)n;
        by = (byte)ES[by & 0xFF];
        by2 = (byte)ES[by2 & 0xFF];
        by3 = (byte)ES[by3 & 0xFF];
        by4 = (byte)ES[by4 & 0xFF];
        return by4 & 0xFF | (by3 & 0xFF) << 8 | (by2 & 0xFF) << 16 | (by & 0xFF) << 24;
    }

    private static int rotByte(int n) {
        byte[] byArray = Utils.wordToBytes(n);
        return Utils.bytesToWord(byArray[1], byArray[2], byArray[3], byArray[0]);
    }

    void setIVTraceOS(ObjectOutputStream objectOutputStream) {
        this.traceOS = objectOutputStream;
    }

    static {
        AES.initGeneric();
    }
}

