/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;

public class SubjectKeyIDExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_subjectKeyIdentifier;
    private byte[] keyID = null;

    public SubjectKeyIDExtension() {
        super(TYPE);
    }

    public SubjectKeyIDExtension(byte[] byArray) {
        this(byArray, false);
    }

    public SubjectKeyIDExtension(byte[] byArray, boolean bl) {
        super(TYPE, bl);
        this.keyID = byArray;
        this.setValue(this.toByteArray());
    }

    public SubjectKeyIDExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public byte[] getSubjectKeyID() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyID;
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(new ASN1OctetString(this.keyID));
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            this.keyID = ASN1OctetString.inputValue(new UnsyncByteArrayInputStream(this.getValue()));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "subjectKeyIDExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = " + (this.getSubjectKeyID() != null ? Utils.toHexString(this.getSubjectKeyID()) : "") + "}";
    }
}

