/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.GeneralName;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class SubjectAltNameExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_subjectAltName;
    private Vector subjAltName = new Vector();

    public SubjectAltNameExtension() {
        super(TYPE);
    }

    public SubjectAltNameExtension(GeneralName generalName) {
        this(generalName, false);
    }

    public SubjectAltNameExtension(GeneralName generalName, boolean bl) {
        super(TYPE, bl);
        this.subjAltName.addElement(generalName);
        this.setValue(this.toByteArray());
    }

    public SubjectAltNameExtension(Vector vector) {
        this(vector, false);
    }

    public SubjectAltNameExtension(Vector vector, boolean bl) {
        super(TYPE, bl);
        this.subjAltName = vector;
        this.setValue(this.toByteArray());
    }

    public SubjectAltNameExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public Enumeration subjectAltName() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.subjAltName.elements();
    }

    public void addSubjectAltName(GeneralName generalName) {
        this.subjAltName.addElement(generalName);
        this.setValue(this.toByteArray());
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(new ASN1Sequence(this.subjAltName));
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            this.subjAltName = new Vector();
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.subjAltName.addElement(new GeneralName(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.terminate();
            if (this.subjAltName.size() == 0) {
                throw new ASN1FormatException("No GeneralName defined for extension");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("subjectAltNameExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.subjAltName != null) {
            stringBuffer.append("subjectAltNames = {");
            boolean bl = false;
            int n = this.subjAltName.size();
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((GeneralName)this.subjAltName.elementAt(i)).toString());
                bl = true;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

