/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.GeneralName;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class NameConstraintsExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_nameConstraints;
    private Vector permitted;
    private Vector excluded;

    public NameConstraintsExtension() {
        super(TYPE);
    }

    public NameConstraintsExtension(Vector vector, Vector vector2) {
        this(vector, vector2, true);
    }

    public NameConstraintsExtension(Vector vector, Vector vector2, boolean bl) {
        super(TYPE, bl);
        this.permitted = vector;
        this.excluded = vector2;
        this.setValue(this.toByteArray());
    }

    public NameConstraintsExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public Vector getPermittedSubtrees() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.permitted;
    }

    public Vector getExcludedSubtrees() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.excluded;
    }

    public void addPermittedSubtree(GeneralName generalName) {
        if (this.permitted == null) {
            this.permitted = new Vector();
        }
        this.permitted.addElement(generalName);
        this.setValue(this.toByteArray());
    }

    public void addExcludedSubtree(GeneralName generalName) {
        if (this.excluded == null) {
            this.excluded = new Vector();
        }
        this.excluded.addElement(generalName);
        this.setValue(this.toByteArray());
    }

    private byte[] toByteArray() {
        ASN1Sequence aSN1Sequence;
        int n;
        int n2;
        Object object;
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        if (this.permitted != null && this.permitted.size() > 0) {
            object = new ASN1GenericConstructed(0);
            n2 = this.permitted.size();
            for (n = 0; n < n2; ++n) {
                aSN1Sequence = new ASN1Sequence();
                aSN1Sequence.addElement((GeneralName)this.permitted.elementAt(n));
                ((ASN1GenericConstructed)object).addElement(aSN1Sequence);
            }
            aSN1Sequence2.addElement((ASN1Object)object);
        }
        if (this.excluded != null && this.excluded.size() > 0) {
            object = new ASN1GenericConstructed(1);
            n2 = this.excluded.size();
            for (n = 0; n < n2; ++n) {
                aSN1Sequence = new ASN1Sequence();
                aSN1Sequence.addElement((GeneralName)this.excluded.elementAt(n));
                ((ASN1GenericConstructed)object).addElement(aSN1Sequence);
            }
            aSN1Sequence2.addElement((ASN1Object)object);
        }
        object = Utils.toBytes(aSN1Sequence2);
        this.isDecoded = true;
        return object;
    }

    private void decodeValue() {
        try {
            ASN1Sequence aSN1Sequence;
            ASN1SequenceInputStream aSN1SequenceInputStream;
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            if (aSN1SequenceInputStream2.hasMoreData() && aSN1SequenceInputStream2.getCurrentTag() == 0) {
                aSN1SequenceInputStream2.setCurrentTag(16);
                aSN1SequenceInputStream = new ASN1SequenceInputStream(aSN1SequenceInputStream2);
                this.permitted = new Vector();
                while (aSN1SequenceInputStream.hasMoreData()) {
                    aSN1Sequence = new ASN1Sequence(aSN1SequenceInputStream);
                    this.permitted.addElement(new GeneralName(Utils.toStream(aSN1Sequence.elementAt(0))));
                }
                aSN1SequenceInputStream.terminate();
            }
            if (aSN1SequenceInputStream2.hasMoreData() && aSN1SequenceInputStream2.getCurrentTag() == 1) {
                aSN1SequenceInputStream2.setCurrentTag(16);
                aSN1SequenceInputStream = new ASN1SequenceInputStream(aSN1SequenceInputStream2);
                this.excluded = new Vector();
                while (aSN1SequenceInputStream.hasMoreData()) {
                    aSN1Sequence = new ASN1Sequence(aSN1SequenceInputStream);
                    this.excluded.addElement(new GeneralName(Utils.toStream(aSN1Sequence.elementAt(0))));
                }
                aSN1SequenceInputStream.terminate();
            }
            aSN1SequenceInputStream2.terminate();
            if (this.permitted == null && this.excluded == null) {
                throw new ASN1FormatException("No name constraints defined for extension");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        int n;
        int n2;
        boolean bl;
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("nameConstraintsExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean bl2 = false;
        if (this.getPermittedSubtrees() != null) {
            stringBuffer.append("permitted = {");
            bl = false;
            n2 = this.getPermittedSubtrees().size();
            for (n = 0; n < n2; ++n) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((GeneralName)this.getPermittedSubtrees().elementAt(n)).toString());
                bl = true;
            }
            stringBuffer.append("}");
            bl2 = true;
        }
        if (this.getExcludedSubtrees() != null) {
            if (bl2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("excluded = {");
            bl = false;
            n2 = this.getExcludedSubtrees().size();
            for (n = 0; n < n2; ++n) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((GeneralName)this.getExcludedSubtrees().elementAt(n)).toString());
                bl = true;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

