/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;

public class KeyUsageExtension
extends X509Extension {
    public static final int DIGITAL_SIGNATURE = 0;
    public static final int NON_REPUDIATION = 1;
    public static final int KEY_ENCIPHERMENT = 2;
    public static final int DATA_ENCIPHERMENT = 3;
    public static final int KEY_AGREEMENT = 4;
    public static final int KEY_CERT_SIGN = 5;
    public static final int CRL_SIGN = 6;
    public static final int ENCIPHER_ONLY = 7;
    public static final int DECIPHER_ONLY = 8;
    private static final String[] description = new String[]{"DIGITAL SIGNATURE", "NON REPUDIATION", "KEY ENCIPHERMENT", "DATA ENCIPHERMENT", "KEY AGREEMENT", "KEY CERT_SIGN", "CRL SIGN", "ENCIPHER ONLY", "DECIPHER ONLY"};
    private static final int[] LIST = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final ASN1ObjectID TYPE = PKIX.id_ce_keyUsage;
    private boolean[] keyUsage = new boolean[LIST.length];

    public KeyUsageExtension() {
        super(TYPE);
    }

    public KeyUsageExtension(boolean bl) {
        super(TYPE, bl);
        this.setValue(this.toByteArray());
    }

    public KeyUsageExtension(int[] nArray, boolean bl) {
        super(TYPE, bl);
        this.setUsageFlags(nArray);
    }

    public KeyUsageExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public boolean hasUsageFlag(int n) {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyUsage != null && n < this.keyUsage.length ? this.keyUsage[n] : false;
    }

    public void setUsageFlag(int n) {
        this.doSetUsageFlag(n);
        this.setValue(this.toByteArray());
    }

    public void setUsageFlags(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            this.doSetUsageFlag(nArray[i]);
        }
        this.setValue(this.toByteArray());
    }

    public void clearUsageFlag(int n) {
        if (this.keyUsage != null && n < this.keyUsage.length) {
            this.keyUsage[n] = false;
        }
        this.setValue(this.toByteArray());
    }

    public void clearAllUsageFlags() {
        if (this.keyUsage != null) {
            int n = this.keyUsage.length;
            for (int i = 0; i < n; ++i) {
                this.keyUsage[i] = false;
            }
            this.setValue(this.toByteArray());
        }
    }

    private void doSetUsageFlag(int n) {
        if (this.keyUsage == null || this.keyUsage.length < LIST.length) {
            boolean[] blArray = new boolean[LIST.length];
            if (this.keyUsage != null) {
                System.arraycopy(this.keyUsage, 0, blArray, 0, this.keyUsage.length);
            }
            this.keyUsage = blArray;
        }
        this.keyUsage[n] = true;
    }

    private byte[] toByteArray() {
        ASN1BitString aSN1BitString = new ASN1BitString(this.keyUsage.length);
        for (int i = 0; i < this.keyUsage.length; ++i) {
            if (!this.keyUsage[i]) continue;
            aSN1BitString.setBit(i);
        }
        byte[] byArray = Utils.toBytes(aSN1BitString);
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            int n;
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1BitString aSN1BitString = new ASN1BitString(unsyncByteArrayInputStream);
            this.keyUsage = new boolean[aSN1BitString.bitLength()];
            try {
                for (n = 0; n < this.keyUsage.length; ++n) {
                    this.keyUsage[n] = aSN1BitString.testBit(n);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ASN1FormatException("Unknown key usage flag: " + n);
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("keyUsageExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean bl = false;
        for (int i = 0; i < LIST.length; ++i) {
            if (!this.hasUsageFlag(i)) continue;
            if (bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(description[i]);
            bl = true;
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

