/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1Boolean;
import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1GenericPrimitive;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.CRLDistPointName;
import com.phaos.cert.CRLReason;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;

public class IssuingDistPointExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_issuingDistributionPoint;
    private CRLDistPointName distPointName = null;
    private boolean onlyContainsUserCerts = false;
    private boolean onlyContainsCACerts = false;
    private boolean[] reasons;
    private int reasonsCount;
    private boolean indirectCRL = false;

    public IssuingDistPointExtension() {
        super(TYPE);
    }

    public IssuingDistPointExtension(boolean bl) {
        super(TYPE, bl);
        this.setValue(this.toByteArray());
    }

    public IssuingDistPointExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public CRLDistPointName getDistPointName() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.distPointName;
    }

    public void setDistPointName(CRLDistPointName cRLDistPointName) {
        this.distPointName = cRLDistPointName;
        this.setValue(this.toByteArray());
    }

    public boolean onlyContainsUserCerts() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.onlyContainsUserCerts;
    }

    public void setOnlyContainsUserCerts(boolean bl) {
        this.onlyContainsUserCerts = bl;
        this.setValue(this.toByteArray());
    }

    public boolean onlyContainsCACerts() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.onlyContainsCACerts;
    }

    public void setOnlyContainsCACerts(boolean bl) {
        this.onlyContainsCACerts = bl;
        this.setValue(this.toByteArray());
    }

    public boolean isIndirectCRL() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.indirectCRL;
    }

    public void setIsIndirectCRL(boolean bl) {
        this.indirectCRL = bl;
        this.setValue(this.toByteArray());
    }

    public boolean hasReasonFlag(CRLReason cRLReason) {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        int n = cRLReason.getValue();
        return this.reasons != null && n < this.reasons.length ? this.reasons[n] : false;
    }

    public void setReasonFlag(CRLReason cRLReason) {
        this.doSetReasonFlag(cRLReason);
        this.setValue(this.toByteArray());
    }

    public void setReasonFlags(CRLReason[] cRLReasonArray) {
        int n = cRLReasonArray.length;
        for (int i = 0; i < n; ++i) {
            this.doSetReasonFlag(cRLReasonArray[i]);
        }
        this.setValue(this.toByteArray());
    }

    public void clearReasonFlag(CRLReason cRLReason) {
        int n = cRLReason.getValue();
        if (this.reasons != null && n < this.reasons.length) {
            this.reasons[n] = false;
        }
        this.setValue(this.toByteArray());
    }

    public void clearAllReasonFlags() {
        if (this.reasons != null) {
            int n = this.reasons.length;
            for (int i = 0; i < n; ++i) {
                this.reasons[i] = false;
            }
            this.setValue(this.toByteArray());
        }
    }

    private void doSetReasonFlag(CRLReason cRLReason) {
        if (this.reasons == null || this.reasons.length < CRLReason.LIST.length) {
            boolean[] blArray = new boolean[CRLReason.LIST.length];
            if (this.reasons != null) {
                System.arraycopy(this.reasons, 0, blArray, 0, this.reasons.length);
            }
            this.reasons = blArray;
        }
        this.reasons[cRLReason.getValue()] = true;
        ++this.reasonsCount;
    }

    private byte[] toByteArray() {
        Object object;
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.distPointName != null) {
            aSN1Sequence.addElement(new ASN1GenericConstructed(this.distPointName, 0));
        }
        if (this.onlyContainsUserCerts) {
            aSN1Sequence.addElement(new ASN1GenericPrimitive(new ASN1Boolean(true), 1));
        }
        if (this.onlyContainsCACerts) {
            aSN1Sequence.addElement(new ASN1GenericPrimitive(new ASN1Boolean(true), 2));
        }
        if (this.reasons != null && this.reasonsCount > 0) {
            object = new ASN1BitString(this.reasons.length);
            for (int i = 0; i < this.reasons.length; ++i) {
                if (!this.reasons[i]) continue;
                ((ASN1BitString)object).setBit(i);
            }
            aSN1Sequence.addElement(new ASN1GenericPrimitive((ASN1Object)object, 3));
        }
        if (this.indirectCRL) {
            aSN1Sequence.addElement(new ASN1GenericPrimitive(new ASN1Boolean(true), 4));
        }
        object = Utils.toBytes(aSN1Sequence);
        this.isDecoded = true;
        return object;
    }

    private void decodeValue() {
        try {
            Object object;
            UnsyncByteArrayInputStream unsyncByteArrayInputStream;
            ASN1SequenceInputStream aSN1SequenceInputStream;
            if (this.getValue() == null) {
                this.setValue(this.toByteArray());
            }
            if ((aSN1SequenceInputStream = new ASN1SequenceInputStream(unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue()))).hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 0) {
                object = new ASN1ConstructedInputStream((InputStream)aSN1SequenceInputStream, 0);
                this.distPointName = new CRLDistPointName((InputStream)object);
                ((ASN1ConstructedInputStream)object).terminate();
            } else {
                this.distPointName = null;
            }
            if (aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 1) {
                aSN1SequenceInputStream.setCurrentTag(1);
                this.onlyContainsUserCerts = ASN1Boolean.inputValue(aSN1SequenceInputStream);
            } else {
                this.onlyContainsUserCerts = false;
            }
            if (aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 2) {
                aSN1SequenceInputStream.setCurrentTag(1);
                this.onlyContainsCACerts = ASN1Boolean.inputValue(aSN1SequenceInputStream);
            } else {
                this.onlyContainsCACerts = false;
            }
            if (aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 3) {
                int n;
                aSN1SequenceInputStream.setCurrentTag(3);
                object = new ASN1BitString(aSN1SequenceInputStream);
                this.reasons = new boolean[((ASN1BitString)object).bitLength()];
                try {
                    for (n = 0; n < this.reasons.length; ++n) {
                        this.reasons[n] = ((ASN1BitString)object).testBit(n);
                        ++this.reasonsCount;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new ASN1FormatException("Unknown reasons flag: " + n);
                }
            } else {
                this.reasons = null;
                this.reasonsCount = 0;
            }
            if (aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 4) {
                aSN1SequenceInputStream.setCurrentTag(1);
                this.indirectCRL = ASN1Boolean.inputValue(aSN1SequenceInputStream);
            } else {
                this.indirectCRL = false;
            }
            aSN1SequenceInputStream.terminate();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("issuingDistPointExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean bl = false;
        if (this.getDistPointName() != null) {
            stringBuffer.append("distPointName = " + this.getDistPointName());
            bl = true;
        }
        if (bl) {
            stringBuffer.append(", ");
        }
        stringBuffer.append("onlyContainsUserCerts = " + this.onlyContainsUserCerts());
        stringBuffer.append(", onlyContainsCACerts = " + this.onlyContainsCACerts());
        stringBuffer.append(", onlySomeReasons = {");
        if (this.reasons != null) {
            boolean bl2 = false;
            for (int i = 0; i < this.reasons.length; ++i) {
                if (bl2) {
                    stringBuffer.append(", ");
                }
                if (this.reasons[i]) {
                    stringBuffer.append(CRLReason.LIST[i]);
                }
                bl2 = true;
            }
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append("}");
        stringBuffer.append(", indirectCRL = " + this.isIndirectCRL());
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

