/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.GeneralName;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class IssuerAltNameExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_issuerAltName;
    private Vector issuerAltName = new Vector();

    public IssuerAltNameExtension() {
        super(TYPE);
    }

    public IssuerAltNameExtension(GeneralName generalName) {
        this(generalName, false);
    }

    public IssuerAltNameExtension(GeneralName generalName, boolean bl) {
        super(TYPE, bl);
        this.issuerAltName.addElement(generalName);
        this.setValue(this.toByteArray());
    }

    public IssuerAltNameExtension(Vector vector) {
        this(vector, false);
    }

    public IssuerAltNameExtension(Vector vector, boolean bl) {
        super(TYPE, bl);
        this.issuerAltName = vector;
        this.setValue(this.toByteArray());
    }

    public IssuerAltNameExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public Enumeration issuerAltName() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.issuerAltName.elements();
    }

    public void addIssuerAltName(GeneralName generalName) {
        this.issuerAltName.addElement(generalName);
        this.setValue(this.toByteArray());
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(new ASN1Sequence(this.issuerAltName));
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(byteArrayInputStream);
            this.issuerAltName = new Vector();
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.issuerAltName.addElement(new GeneralName(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.terminate();
            if (this.issuerAltName.size() == 0) {
                throw new ASN1FormatException("No GeneralName defined for extension");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("issuerAltNameExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.issuerAltName != null) {
            stringBuffer.append("issuerAltNames = {");
            boolean bl = false;
            int n = this.issuerAltName.size();
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((GeneralName)this.issuerAltName.elementAt(i)).toString());
                bl = true;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

