/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class ExtKeyUsageExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_extKeyUsage;
    private Vector keyPurposes = new Vector();

    public ExtKeyUsageExtension() {
        super(TYPE);
    }

    public ExtKeyUsageExtension(ASN1ObjectID aSN1ObjectID) {
        this(aSN1ObjectID, false);
    }

    public ExtKeyUsageExtension(ASN1ObjectID aSN1ObjectID, boolean bl) {
        super(TYPE, bl);
        this.keyPurposes.addElement(aSN1ObjectID);
        this.setValue(this.toByteArray());
    }

    public ExtKeyUsageExtension(Vector vector, boolean bl) {
        super(TYPE, bl);
        this.keyPurposes = vector;
        this.setValue(this.toByteArray());
    }

    public ExtKeyUsageExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public void addKeyPurpose(ASN1ObjectID aSN1ObjectID) {
        this.keyPurposes.addElement(aSN1ObjectID);
        this.setValue(this.toByteArray());
    }

    public Enumeration getKeyPurposes() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyPurposes.elements();
    }

    public boolean hasKeyPurpose(ASN1ObjectID aSN1ObjectID) {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyPurposes.contains(aSN1ObjectID);
    }

    private byte[] toByteArray() {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        int n = this.keyPurposes.size();
        for (int i = 0; i < n; ++i) {
            aSN1Sequence.addElement((ASN1ObjectID)this.keyPurposes.elementAt(i));
        }
        byte[] byArray = Utils.toBytes(aSN1Sequence);
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            this.keyPurposes = new Vector();
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(new UnsyncByteArrayInputStream(this.getValue()));
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.keyPurposes.addElement(new ASN1ObjectID(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.terminate();
            if (this.keyPurposes.size() == 0) {
                throw new ASN1FormatException("Malformed extension contents");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("extKeyUsageExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.keyPurposes != null) {
            stringBuffer.append("OIDs of key usage = {");
            boolean bl = false;
            int n = this.keyPurposes.size();
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((ASN1ObjectID)this.keyPurposes.elementAt(i)).toString());
                bl = true;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

