/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class DeltaCRLIndicatorExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_deltaCRLIndicator;
    private BigInteger baseCRLNumber = null;

    public DeltaCRLIndicatorExtension() {
        super(TYPE);
    }

    public DeltaCRLIndicatorExtension(BigInteger bigInteger) {
        this(bigInteger, true);
    }

    private DeltaCRLIndicatorExtension(BigInteger bigInteger, boolean bl) {
        super(TYPE, bl);
        this.baseCRLNumber = bigInteger;
        this.setValue(this.toByteArray());
    }

    public DeltaCRLIndicatorExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public BigInteger getBaseCRLNumber() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.baseCRLNumber;
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(new ASN1Integer(this.baseCRLNumber));
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            this.baseCRLNumber = ASN1Integer.inputValue(new UnsyncByteArrayInputStream(this.getValue()));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "deltaCRLIndicatorExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = " + this.getBaseCRLNumber() + "}";
    }
}

