/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class CRLNumberExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_cRLNumber;
    private BigInteger crlNumber = null;

    public CRLNumberExtension() {
        super(TYPE);
    }

    public CRLNumberExtension(BigInteger bigInteger) {
        this(bigInteger, false);
    }

    public CRLNumberExtension(BigInteger bigInteger, boolean bl) {
        super(TYPE, bl);
        this.crlNumber = bigInteger;
        this.setValue(this.toByteArray());
    }

    public CRLNumberExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public BigInteger getCRLNumber() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.crlNumber;
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(new ASN1Integer(this.crlNumber));
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            this.crlNumber = ASN1Integer.inputValue(new UnsyncByteArrayInputStream(this.getValue()));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "CRLNumberExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = " + this.getCRLNumber() + "}";
    }
}

