/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert.extension;

import com.phaos.ASN1.ASN1Boolean;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.PKIX;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class BasicConstraintsExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_basicConstraints;
    private boolean ca = false;
    private BigInteger pathLen = null;

    public BasicConstraintsExtension() {
        super(TYPE);
    }

    public BasicConstraintsExtension(boolean bl) {
        this(bl, true);
    }

    public BasicConstraintsExtension(boolean bl, boolean bl2) {
        super(TYPE, bl2);
        this.ca = bl;
        this.setValue(this.toByteArray());
    }

    public BasicConstraintsExtension(BigInteger bigInteger) {
        this(bigInteger, true);
    }

    public BasicConstraintsExtension(BigInteger bigInteger, boolean bl) {
        super(TYPE, bl);
        this.ca = true;
        this.pathLen = bigInteger;
        this.setValue(this.toByteArray());
    }

    public BasicConstraintsExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public boolean getCA() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.ca;
    }

    public BigInteger getPathLen() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.pathLen;
    }

    private byte[] toByteArray() {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.ca) {
            aSN1Sequence.addElement(new ASN1Boolean(true));
        }
        if (this.pathLen != null) {
            aSN1Sequence.addElement(new ASN1Integer(this.pathLen));
        }
        byte[] byArray = Utils.toBytes(aSN1Sequence);
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            if (aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 1) {
                this.ca = ASN1Boolean.inputValue(aSN1SequenceInputStream);
            }
            if (aSN1SequenceInputStream.hasMoreData()) {
                if (this.ca) {
                    this.pathLen = ASN1Integer.inputValue(aSN1SequenceInputStream);
                } else {
                    throw new ASN1FormatException("Malformed extension contents");
                }
            }
            aSN1SequenceInputStream.terminate();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "basicConstraintsExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [ CA = " + this.getCA() + (this.getPathLen() != null ? ", pathLen = " + this.getPathLen() : "") + "]}";
    }
}

