/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.X509Extension;
import com.phaos.utils.UnsyncHashtable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class X509ExtensionSet
implements ASN1Object {
    private UnsyncHashtable extTable = new UnsyncHashtable();
    private Vector extList = new Vector();
    private ASN1Sequence seq = null;

    public X509ExtensionSet() {
    }

    public X509ExtensionSet(Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.addExtension((X509Extension)vector.elementAt(i));
        }
    }

    public X509ExtensionSet(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public X509Extension addExtension(X509Extension x509Extension) {
        this.reset();
        X509Extension x509Extension2 = (X509Extension)this.extTable.get(x509Extension.getType());
        if (x509Extension2 != null) {
            this.extList.removeElement(x509Extension2);
        }
        this.extList.addElement(x509Extension);
        this.extTable.put(x509Extension.getType(), x509Extension);
        return x509Extension2;
    }

    public X509Extension getExtension(ASN1ObjectID aSN1ObjectID) {
        return (X509Extension)this.extTable.get(aSN1ObjectID);
    }

    public Enumeration types() {
        return this.extTable.keys();
    }

    public Vector getExtensions() {
        Vector vector = new Vector();
        int n = this.extList.size();
        for (int i = 0; i < n; ++i) {
            vector.addElement(this.extList.elementAt(i));
        }
        return vector;
    }

    public int size() {
        return this.extList.size();
    }

    public boolean hasExtension(ASN1ObjectID aSN1ObjectID) {
        return this.extTable.containsKey(aSN1ObjectID);
    }

    public boolean hasUnrecognizedCriticalExtension() {
        int n = this.extList.size();
        for (int i = 0; i < n; ++i) {
            X509Extension x509Extension = (X509Extension)this.extList.elementAt(i);
            if (!x509Extension.getCritical() || x509Extension.isRecognized()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        int n = this.extList.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.extList.elementAt(i).toString());
            if (i >= n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.extList.removeAllElements();
        this.extTable.clear();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        while (aSN1SequenceInputStream.hasMoreData()) {
            this.addExtension(X509Extension.inputInstance(aSN1SequenceInputStream));
        }
        aSN1SequenceInputStream.terminate();
        this.reset();
        if (this.size() == 0) {
            throw new ASN1FormatException("Extension set must contain at least 1 extension");
        }
    }

    private void reset() {
        this.seq = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.seq == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            int n = this.extList.size();
            for (int i = 0; i < n; ++i) {
                aSN1Sequence.addElement((X509Extension)this.extList.elementAt(i));
            }
            this.seq = aSN1Sequence;
        }
        return this.seq;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1Sequence().length();
    }
}

