/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Boolean;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.PKIX;
import com.phaos.utils.OIDManager;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class X509Extension
implements ASN1Object {
    public static final ASN1ObjectID id_netscape_ce = PKIX.id_netscape_ce;
    public static final ASN1ObjectID id_netscape_ce_type = PKIX.id_netscape_ce_type;
    public static final ASN1ObjectID id_set_ce = PKIX.id_set_ce;
    public static final ASN1ObjectID id_set_ce_type = PKIX.id_set_ce_type;
    protected boolean isDecoded = false;
    private ASN1ObjectID type;
    private boolean critical;
    private byte[] value;
    private ASN1Sequence contents = null;

    public X509Extension() {
    }

    protected X509Extension(ASN1ObjectID aSN1ObjectID) {
        this(aSN1ObjectID, false);
    }

    protected X509Extension(ASN1ObjectID aSN1ObjectID, boolean bl) {
        this.type = aSN1ObjectID;
        this.critical = bl;
    }

    public X509Extension(ASN1ObjectID aSN1ObjectID, byte[] byArray) {
        this(aSN1ObjectID, false, byArray);
    }

    public X509Extension(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this(aSN1ObjectID, false, Utils.toBytes(aSN1Object));
    }

    public X509Extension(ASN1ObjectID aSN1ObjectID, boolean bl, byte[] byArray) {
        this.type = aSN1ObjectID;
        this.critical = bl;
        this.value = byArray;
    }

    public X509Extension(ASN1ObjectID aSN1ObjectID, boolean bl, ASN1Object aSN1Object) {
        this(aSN1ObjectID, bl, Utils.toBytes(aSN1Object));
    }

    public X509Extension(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public X509Extension(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(aSN1Sequence);
    }

    public static X509Extension inputInstance(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(aSN1SequenceInputStream);
        boolean bl = aSN1SequenceInputStream.getCurrentTag() == 1 ? ASN1Boolean.inputValue(aSN1SequenceInputStream) : false;
        byte[] byArray = ASN1OctetString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        String string = OIDManager.getOIDManager().getProperty(aSN1ObjectID, "extension");
        if (string == null) {
            return new X509Extension(aSN1ObjectID, bl, byArray);
        }
        X509Extension x509Extension = null;
        try {
            x509Extension = (X509Extension)Class.forName(string).newInstance();
            x509Extension.setCritical(bl);
            x509Extension.setValue(byArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new IOException(instantiationException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException.toString());
        }
        return x509Extension;
    }

    public boolean isRecognized() {
        return OIDManager.getOIDManager().getProperty(this.getType(), "extension") != null;
    }

    public ASN1ObjectID getID() {
        return this.getType();
    }

    public ASN1ObjectID getType() {
        return this.type;
    }

    public boolean getCritical() {
        return this.critical;
    }

    protected void setCritical(boolean bl) {
        this.critical = bl;
        this.reset();
    }

    public byte[] getValue() {
        return this.value;
    }

    protected void setValue(byte[] byArray) {
        this.value = byArray;
        this.reset();
        this.isDecoded = false;
    }

    public ASN1Object getASN1Value() throws IOException {
        return ASN1Utils.inputASN1Object(new UnsyncByteArrayInputStream(this.value));
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(this.type);
        if (this.critical) {
            aSN1Sequence.addElement(new ASN1Boolean(this.critical));
        }
        aSN1Sequence.addElement(new ASN1OctetString(this.value));
        this.contents = aSN1Sequence;
        return this.contents;
    }

    private void reset() {
        this.contents = null;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.reset();
        this.isDecoded = false;
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.type = new ASN1ObjectID(aSN1SequenceInputStream);
        this.critical = aSN1SequenceInputStream.getCurrentTag() == 1 ? ASN1Boolean.inputValue(aSN1SequenceInputStream) : false;
        this.value = ASN1OctetString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    public String toString() {
        return "oid = " + this.type + ", critical = " + this.critical + ", value = " + Utils.toHexString(this.value);
    }
}

