/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1Date;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.CRL;
import com.phaos.cert.Certificate;
import com.phaos.cert.CertificateRequest;
import com.phaos.cert.Entity;
import com.phaos.cert.PKIX;
import com.phaos.cert.SPKAC;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509Attributes;
import com.phaos.cert.X509Extension;
import com.phaos.cert.X509ExtensionSet;
import com.phaos.cert.extension.BasicConstraintsExtension;
import com.phaos.cert.extension.KeyUsageExtension;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.Signature;
import com.phaos.crypto.SignatureException;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.OutputGenerationException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class X509
extends Certificate
implements ASN1Object,
Externalizable {
    private ASN1Sequence tbsCert;
    private AlgorithmIdentifier sigAlgID;
    private byte[] sigBytes;
    private BigInteger serialNo;
    private X500Name issuer;
    private Date notBeforeDate;
    private Date notAfterDate;
    private X509ExtensionSet extensions = null;
    private PrivateKey issuerPrivateKey;
    private CRL issuerCRL;
    private X509 issuerCertificate;
    protected boolean isDecoded = false;
    private ASN1Sequence contents = null;
    private transient MessageDigest md5 = null;

    public X509() {
    }

    public X509(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public X509(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.input(fileInputStream);
        ((InputStream)fileInputStream).close();
    }

    public X509(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        this.input(inputStream);
        inputStream.close();
    }

    public X509(byte[] byArray) throws IOException {
        this(new UnsyncByteArrayInputStream(byArray));
    }

    public X509(CertificateRequest certificateRequest, X509 x509, PrivateKey privateKey, BigInteger bigInteger, int n) throws SignatureException {
        this();
        this.holder = certificateRequest.getSubject();
        this.key = certificateRequest.getPublicKey();
        this.setIssuerCertificate(x509);
        this.issuer = (X500Name)x509.getHolder();
        this.issuerPrivateKey = privateKey;
        this.serialNo = bigInteger;
        this.setValidity(n);
        this.sign();
    }

    public X509(X500Name x500Name, SPKAC sPKAC, X509 x509, PrivateKey privateKey, BigInteger bigInteger, int n) throws SignatureException {
        this();
        this.holder = x500Name;
        this.key = sPKAC.getPublicKey();
        this.setIssuerCertificate(x509);
        this.issuer = (X500Name)x509.getHolder();
        this.issuerPrivateKey = privateKey;
        this.serialNo = bigInteger;
        this.setValidity(n);
        this.sign();
    }

    public X509(X500Name x500Name, PublicKey publicKey, X500Name x500Name2, PrivateKey privateKey, BigInteger bigInteger, int n) throws SignatureException {
        this();
        this.holder = x500Name;
        this.key = publicKey;
        this.issuer = x500Name2;
        this.issuerPrivateKey = privateKey;
        this.serialNo = bigInteger;
        this.setValidity(n);
        this.sign();
    }

    public X509(X500Name x500Name, PublicKey publicKey, X500Name x500Name2, PrivateKey privateKey, BigInteger bigInteger, Date date, Date date2) throws SignatureException {
        this();
        this.holder = x500Name;
        this.key = publicKey;
        this.issuer = x500Name2;
        this.issuerPrivateKey = privateKey;
        this.serialNo = bigInteger;
        this.notBeforeDate = date;
        this.notAfterDate = date2;
        this.sign();
    }

    protected void decode() {
        this.isDecoded = true;
    }

    public void sign() throws SignatureException {
        this.sign(RandomBitsSource.getDefault());
    }

    public void sign(RandomBitsSource randomBitsSource) throws SignatureException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.issuerPrivateKey == null) {
            throw new SignatureException("Cannot sign certificate, no issuer private key set");
        }
        ASN1Sequence aSN1Sequence = this.getTBSCert();
        try {
            Signature signature = Signature.getInstance(this.issuerPrivateKey);
            if (this.sigAlgID == null) {
                throw new SignatureException("Cannot sign certificate, no signature algorithm set");
            }
            signature.setAlgID(this.sigAlgID);
            signature.setRandomBitsSource(randomBitsSource);
            signature.setDocument(Utils.toBytes(aSN1Sequence));
            this.sigBytes = signature.sign();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new SignatureException(algorithmIdentifierException.toString());
        }
        this.reset();
    }

    public byte[] getSigBytes() throws SignatureException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.sigBytes == null) {
            this.sign();
        }
        return this.sigBytes;
    }

    public void initialize(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void save(OutputStream outputStream) throws IOException {
        this.output(outputStream);
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        Object object;
        Serializable serializable;
        Object object2;
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.tbsCert = new ASN1Sequence(aSN1SequenceInputStream);
        this.sigAlgID = new AlgorithmIdentifier(aSN1SequenceInputStream);
        this.sigBytes = ASN1BitString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(Utils.toStream(this.tbsCert));
        if (aSN1SequenceInputStream2.getCurrentTag() == 0) {
            object2 = new ASN1ConstructedInputStream(aSN1SequenceInputStream2);
            serializable = ASN1Integer.inputValue((InputStream)object2);
            ((ASN1ConstructedInputStream)object2).terminate();
        }
        this.serialNo = ASN1Integer.inputValue(aSN1SequenceInputStream2);
        object2 = new AlgorithmIdentifier(aSN1SequenceInputStream2);
        if (!((AlgorithmIdentifier)object2).equals(this.sigAlgID)) {
            throw new IOException("Inconsistent signature algorithm IDs");
        }
        serializable = new X500Name(aSN1SequenceInputStream2);
        if (this.issuer == null) {
            this.issuer = serializable;
        } else if (!this.issuer.equals(serializable)) {
            throw new IOException("Expected issuer {" + this.issuer + "}, got issuer {" + serializable + "}");
        }
        ASN1SequenceInputStream aSN1SequenceInputStream3 = new ASN1SequenceInputStream(aSN1SequenceInputStream2);
        this.notBeforeDate = ASN1Date.inputValue(aSN1SequenceInputStream3);
        this.notAfterDate = ASN1Date.inputValue(aSN1SequenceInputStream3);
        aSN1SequenceInputStream3.terminate();
        this.holder = new X500Name(aSN1SequenceInputStream2);
        this.key = CryptoUtils.inputSPKI(aSN1SequenceInputStream2);
        if (aSN1SequenceInputStream2.getCurrentTag() == 1) {
            aSN1SequenceInputStream2.setCurrentTag(3);
            object = ASN1BitString.inputValue(aSN1SequenceInputStream2);
        }
        if (aSN1SequenceInputStream2.getCurrentTag() == 2) {
            aSN1SequenceInputStream2.setCurrentTag(3);
            object = ASN1BitString.inputValue(aSN1SequenceInputStream2);
        }
        if (aSN1SequenceInputStream2.getCurrentTag() == 3) {
            object = new ASN1ConstructedInputStream(aSN1SequenceInputStream2);
            this.extensions = new X509ExtensionSet((InputStream)object);
            ((ASN1ConstructedInputStream)object).terminate();
        } else {
            this.extensions = null;
        }
        aSN1SequenceInputStream2.terminate();
        this.reset();
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    private ASN1Sequence getTBSCert() throws SignatureException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.tbsCert == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            if (this.extensions != null && this.extensions.size() > 0) {
                aSN1Sequence.addElement(new ASN1GenericConstructed(new ASN1Integer(2L), 0));
            }
            aSN1Sequence.addElement(new ASN1Integer(this.serialNo));
            if (this.sigAlgID == null && this.issuerPrivateKey != null) {
                this.sigAlgID = Signature.getInstance(this.issuerPrivateKey).getAlgID();
            }
            if (this.sigAlgID == null) {
                throw new SignatureException("Cannot build to-be-signed certificate, no signature algorithm set");
            }
            aSN1Sequence.addElement(this.sigAlgID);
            aSN1Sequence.addElement(this.issuer);
            ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.notBeforeDate);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(this.notAfterDate);
            aSN1Sequence2.addElement(new ASN1Date(this.notBeforeDate, calendar.get(1) > 2049));
            aSN1Sequence2.addElement(new ASN1Date(this.notAfterDate, calendar2.get(1) > 2049));
            aSN1Sequence.addElement(aSN1Sequence2);
            aSN1Sequence.addElement((X500Name)this.holder);
            aSN1Sequence.addElement(CryptoUtils.subjectPublicKeyInfo(this.key));
            if (this.extensions != null && this.extensions.size() > 0) {
                aSN1Sequence.addElement(new ASN1GenericConstructed(this.extensions, 3));
            }
            this.tbsCert = aSN1Sequence;
        }
        return this.tbsCert;
    }

    private ASN1Sequence toASN1Sequence() throws SignatureException {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.getTBSCert());
            aSN1Sequence.addElement(this.sigAlgID);
            aSN1Sequence.addElement(new ASN1BitString(this.getSigBytes()));
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    private void reset() {
        this.contents = null;
    }

    private void resetAll() {
        this.reset();
        this.tbsCert = null;
        this.sigBytes = null;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        try {
            this.toASN1Sequence().output(outputStream);
        }
        catch (SignatureException signatureException) {
            throw new OutputGenerationException(signatureException.toString());
        }
    }

    @Override
    public int length() {
        try {
            return this.toASN1Sequence().length();
        }
        catch (SignatureException signatureException) {
            throw new StreamableOutputException(signatureException.toString());
        }
    }

    public byte[] getEncoded() {
        try {
            return Utils.toBytes(this.toASN1Sequence());
        }
        catch (SignatureException signatureException) {
            throw new StreamableOutputException(signatureException.toString());
        }
    }

    @Override
    public boolean verify() throws AuthenticationException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.hasUnrecognizedCriticalExtension()) {
            return false;
        }
        if (!this.verifyCertDate()) {
            return false;
        }
        if (this.issuerCertificate != null) {
            if (!this.verifyCertSigner()) {
                return false;
            }
            if (!this.issuer.equals(this.issuerCertificate.getSubject())) {
                return false;
            }
            if (!this.verifyCertSignature()) {
                return false;
            }
        }
        return this.issuerCRL == null || this.verifyCertCRL();
    }

    private boolean verifyCertSigner() {
        BasicConstraintsExtension basicConstraintsExtension;
        if (!this.isDecoded) {
            this.decode();
        }
        if ((basicConstraintsExtension = (BasicConstraintsExtension)this.issuerCertificate.getExtension(PKIX.id_ce_basicConstraints)) != null && !basicConstraintsExtension.getCA()) {
            return false;
        }
        KeyUsageExtension keyUsageExtension = (KeyUsageExtension)this.issuerCertificate.getExtension(PKIX.id_ce_keyUsage);
        return keyUsageExtension == null || !keyUsageExtension.getCritical() || keyUsageExtension.hasUsageFlag(5);
    }

    public boolean verifyCertDate() {
        Date date;
        if (!this.isDecoded) {
            this.decode();
        }
        return !(date = new Date()).before(this.notBeforeDate) && !date.after(this.notAfterDate);
    }

    public boolean verifyCertSignature() throws AuthenticationException {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.issuerCertificate == null) {
            throw new IllegalStateException("Issuer certificate not set");
        }
        try {
            Signature signature = Signature.getInstance(new AlgorithmIdentifier(this.getSigAlgOID()));
            signature.setPublicKey(this.issuerCertificate.getPublicKey());
            signature.setDocument(Utils.toBytes(this.getTBSCert()));
            signature.setSigBytes(this.getSigBytes());
            return signature.verify();
        }
        catch (AuthenticationException authenticationException) {
            return false;
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new AuthenticationException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException(invalidKeyException.toString());
        }
        catch (StreamableOutputException streamableOutputException) {
            throw new AuthenticationException(streamableOutputException.toString());
        }
        catch (SignatureException signatureException) {
            throw new AuthenticationException(signatureException.toString());
        }
    }

    public boolean verifyCertCRL() {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.issuerCRL == null) {
            throw new IllegalStateException("Issuer CRL not set");
        }
        return !this.issuerCRL.isRevoked(this.serialNo);
    }

    @Override
    public Entity getHolder() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.holder;
    }

    public void setHolder(X500Name x500Name) {
        this.holder = x500Name;
        this.resetAll();
    }

    @Override
    public PublicKey getKey() {
        return this.getPublicKey();
    }

    public void setKey(PublicKey publicKey) {
        this.setPublicKey(publicKey);
    }

    @Override
    public PublicKey getPublicKey() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.key;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.key = publicKey;
        this.resetAll();
    }

    public Date getNotBeforeDate() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.notBeforeDate;
    }

    public void setNotBeforeDate(Date date) {
        this.notBeforeDate = date;
        this.resetAll();
    }

    public Date getNotAfterDate() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.notAfterDate;
    }

    public void setNotAfterDate(Date date) {
        this.notAfterDate = date;
        this.resetAll();
    }

    public void setValidity(int n) {
        this.notBeforeDate = new Date();
        this.notAfterDate = Utils.daysFrom(this.notBeforeDate, n);
        this.resetAll();
    }

    public X500Name getSubject() {
        if (!this.isDecoded) {
            this.decode();
        }
        return (X500Name)this.holder;
    }

    public void setSubject(X500Name x500Name) {
        this.holder = x500Name;
        this.resetAll();
    }

    public X500Name getIssuer() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.issuer;
    }

    public void setIssuer(X500Name x500Name) {
        this.issuer = x500Name;
        if (this.issuerCRL != null && !x500Name.equals(this.issuerCRL.getIssuer())) {
            throw new IllegalStateException("Certificate issuer does not match CRL issuer");
        }
        this.resetAll();
    }

    public void setIssuerCertificate(X509 x509) {
        this.issuerCertificate = x509;
        if (this.issuer == null) {
            this.setIssuer(x509.getSubject());
        }
    }

    public void setIssuerPrivateKey(PrivateKey privateKey) {
        this.setIssuerPrivateKey(privateKey, null);
    }

    public void setIssuerPrivateKey(PrivateKey privateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.issuerPrivateKey = privateKey;
        this.setSigAlgID(algorithmIdentifier);
    }

    public void setSigAlgID(AlgorithmIdentifier algorithmIdentifier) {
        this.sigAlgID = algorithmIdentifier;
        this.resetAll();
    }

    public void setIssuerCRL(CRL cRL) {
        if (!this.isDecoded) {
            this.decode();
        }
        this.issuerCRL = cRL;
        if (this.issuer != null && !this.issuer.equals(cRL.getIssuer())) {
            throw new IllegalStateException("CRL issuer does not match certificate issuer");
        }
    }

    public BigInteger getSerialNo() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.serialNo;
    }

    public void setSerialNo(BigInteger bigInteger) {
        this.serialNo = bigInteger;
        this.resetAll();
    }

    public boolean hasUnrecognizedCriticalExtension() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.extensions != null && this.extensions.hasUnrecognizedCriticalExtension();
    }

    public Vector getExtensions() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.extensions != null ? this.extensions.getExtensions() : null;
    }

    public X509ExtensionSet getExtensionSet() {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.extensions;
    }

    public X509Extension getExtension(ASN1ObjectID aSN1ObjectID) {
        if (!this.isDecoded) {
            this.decode();
        }
        return this.extensions != null ? this.extensions.getExtension(aSN1ObjectID) : null;
    }

    public void setExtensions(Vector vector) {
        this.setExtensions(new X509ExtensionSet(vector));
    }

    public void setExtensions(X509ExtensionSet x509ExtensionSet) {
        this.extensions = x509ExtensionSet;
        this.resetAll();
    }

    public void addExtension(X509Extension x509Extension) {
        if (!this.isDecoded) {
            this.decode();
        }
        if (this.extensions == null) {
            this.extensions = new X509ExtensionSet();
        }
        this.extensions.addExtension(x509Extension);
        this.resetAll();
    }

    public X509Attributes getAttributes() {
        if (!this.isDecoded) {
            this.decode();
        }
        return X509Attributes.fromExtensionSet(this.extensions, 0);
    }

    public void setAttributes(X509Attributes x509Attributes) {
        if (!this.isDecoded) {
            this.decode();
        }
        X509ExtensionSet x509ExtensionSet = this.extensions;
        this.extensions = X509Attributes.toExtensionSet(x509Attributes);
        if (x509ExtensionSet != null) {
            Enumeration enumeration = x509ExtensionSet.getExtensions().elements();
            while (enumeration.hasMoreElements()) {
                this.extensions.addExtension((X509Extension)enumeration.nextElement());
            }
        }
        this.resetAll();
    }

    public byte[] getFingerprint() {
        if (!this.isDecoded) {
            this.decode();
        }
        try {
            if (this.md5 == null) {
                this.md5 = MessageDigest.getInstance(AlgID.md5);
            }
            return this.md5.computeDigest(Utils.toBytes(this.toASN1Sequence()));
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalStateException("MD5 class not found. " + algorithmIdentifierException.toString());
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException(signatureException.toString());
        }
    }

    public static byte[] getCertID(X500Name x500Name, BigInteger bigInteger, MessageDigest messageDigest) {
        messageDigest.init();
        messageDigest.updateASCII(x500Name.toString());
        messageDigest.updateASCII(bigInteger.toString());
        messageDigest.computeCurrent();
        return messageDigest.getDigestBits();
    }

    public byte[] getCertID(MessageDigest messageDigest) {
        if (!this.isDecoded) {
            this.decode();
        }
        return X509.getCertID(this.issuer, this.serialNo, messageDigest);
    }

    public ASN1ObjectID getSigAlgOID() {
        try {
            this.getTBSCert();
        }
        catch (SignatureException signatureException) {
            throw new IllegalStateException(signatureException.toString());
        }
        if (this.sigAlgID != null) {
            return this.sigAlgID.getOID();
        }
        throw new IllegalStateException("Signature algorithm not defined");
    }

    public String getSigAlgString() {
        return this.getSigAlgOID().toStringCompact();
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) throws AuthenticationException {
        if (!this.isDecoded) {
            this.decode();
        }
        return CryptoUtils.verifySignature(this.key, byArray, byArray2);
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2, AlgorithmIdentifier algorithmIdentifier) throws AuthenticationException {
        if (!this.isDecoded) {
            this.decode();
        }
        try {
            Signature signature = Signature.getInstance(algorithmIdentifier);
            signature.setPublicKey(this.key);
            signature.setDocument(byArray);
            signature.setSigBytes(byArray2);
            return signature.verify();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new AuthenticationException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException(invalidKeyException.toString());
        }
    }

    public boolean equals(Object object) {
        if (!this.isDecoded) {
            this.decode();
        }
        if (object != null && object instanceof X509) {
            return this.equals((X509)object);
        }
        return false;
    }

    private boolean equals(X509 x509) {
        if (!this.isDecoded) {
            this.decode();
        }
        return Utils.areEqual(Utils.toBytes(this), Utils.toBytes(x509));
    }

    public int hashCode() {
        if (!this.isDecoded) {
            this.decode();
        }
        return new String(Utils.toBytes(this)).hashCode();
    }

    public String toString() {
        if (!this.isDecoded) {
            this.decode();
        }
        String string = "";
        string = string + "{ fingerprint = " + Utils.toHexString(this.getFingerprint());
        string = string + ", notBefore = " + this.notBeforeDate;
        string = string + ", notAfter = " + this.notAfterDate;
        string = string + ", holder = " + this.holder;
        string = string + ", issuer = " + this.issuer;
        string = string + ", serialNo = " + this.serialNo;
        string = string + ", sigAlgOID = " + this.getSigAlgString();
        string = string + ", key = " + this.key;
        if (this.extensions != null && this.extensions.size() > 0) {
            string = string + ", extensions = {";
            boolean bl = false;
            Enumeration enumeration = this.extensions.getExtensions().elements();
            while (enumeration.hasMoreElements()) {
                if (bl) {
                    string = string + ", ";
                }
                string = string + (X509Extension)enumeration.nextElement();
                bl = true;
            }
            string = string + " }";
        }
        string = string + " }";
        return string;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

