/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Set;
import com.phaos.ASN1.ASN1SetInputStream;
import com.phaos.ASN1.ASN1String;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.AttributeTypeAndValue;
import com.phaos.cert.PKIX;
import com.phaos.utils.InvalidFormatException;
import com.phaos.utils.OIDManager;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class X500RDN
implements ASN1Object {
    private Hashtable attrSet = new Hashtable();
    private ASN1Set contents = null;

    public X500RDN() {
    }

    public X500RDN(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this.attrSet.put(aSN1ObjectID, new AttributeTypeAndValue(aSN1ObjectID, aSN1Object));
    }

    public X500RDN(ASN1ObjectID aSN1ObjectID, String string) {
        this.addAttribute(aSN1ObjectID, string);
    }

    public X500RDN(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    X500RDN(String string) {
        this.input(string);
    }

    public void addAttribute(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this.contents = null;
        this.attrSet.put(aSN1ObjectID, new AttributeTypeAndValue(aSN1ObjectID, aSN1Object));
    }

    public void addAttribute(ASN1ObjectID aSN1ObjectID, String string) {
        int n = aSN1ObjectID.equals(PKIX.emailAddress) || aSN1ObjectID.equals(PKIX.id_domainComponent) ? 22 : 19;
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            if (cArray[i] <= '\u007f' && (n != 19 || X500RDN.isASN1Printable(cArray[i]))) continue;
            n = 12;
            break;
        }
        this.addAttribute(aSN1ObjectID, new ASN1String(string, n));
    }

    private void addAttribute(AttributeTypeAndValue attributeTypeAndValue) {
        this.contents = null;
        this.attrSet.put(attributeTypeAndValue.getType(), attributeTypeAndValue);
    }

    public Enumeration types() {
        return this.attrSet.keys();
    }

    public ASN1Object getValue(ASN1ObjectID aSN1ObjectID) {
        AttributeTypeAndValue attributeTypeAndValue = (AttributeTypeAndValue)this.attrSet.get(aSN1ObjectID);
        return attributeTypeAndValue != null ? attributeTypeAndValue.getValue() : null;
    }

    public int hashCode() {
        return Utils.hashBytes(this.toASN1Set());
    }

    private static String fixWhitespace(String string) {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2.charAt(0));
        int n = string2.length();
        for (int i = 1; i < n; ++i) {
            char c = string2.charAt(i);
            if (Character.isWhitespace(c)) {
                if (Character.isWhitespace(string2.charAt(i - 1))) continue;
                stringBuffer.append(' ');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        X500RDN x500RDN = (X500RDN)object;
        if (this.attrSet.size() != x500RDN.attrSet.size()) {
            return false;
        }
        Enumeration enumeration = this.attrSet.elements();
        Enumeration enumeration2 = x500RDN.attrSet.elements();
        while (enumeration.hasMoreElements() && enumeration2.hasMoreElements()) {
            AttributeTypeAndValue attributeTypeAndValue = (AttributeTypeAndValue)enumeration.nextElement();
            AttributeTypeAndValue attributeTypeAndValue2 = (AttributeTypeAndValue)enumeration2.nextElement();
            if (!attributeTypeAndValue.getType().equals(attributeTypeAndValue2.getType())) {
                return false;
            }
            if (attributeTypeAndValue.getValue().getClass() != attributeTypeAndValue2.getValue().getClass()) {
                return false;
            }
            if (attributeTypeAndValue.getValue() instanceof ASN1String) {
                ASN1String aSN1String = (ASN1String)attributeTypeAndValue.getValue();
                ASN1String aSN1String2 = (ASN1String)attributeTypeAndValue2.getValue();
                if (!(aSN1String.getTag() == 19 && aSN1String2.getTag() == 19 ? !X500RDN.fixWhitespace(aSN1String.getValue()).equalsIgnoreCase(X500RDN.fixWhitespace(aSN1String2.getValue())) : !aSN1String.getValue().equals(aSN1String2.getValue()))) continue;
                return false;
            }
            if (Utils.areEqual(Utils.toBytes(attributeTypeAndValue.getValue()), Utils.toBytes(attributeTypeAndValue2.getValue()))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.attrSet.elements();
        while (enumeration.hasMoreElements()) {
            AttributeTypeAndValue attributeTypeAndValue = (AttributeTypeAndValue)enumeration.nextElement();
            String string = X500RDN.getTypeName(attributeTypeAndValue.getType());
            stringBuffer.append(string != null ? string : attributeTypeAndValue.getType().toStringCompact());
            stringBuffer.append('=');
            ASN1Object aSN1Object = attributeTypeAndValue.getValue();
            if (aSN1Object instanceof ASN1String) {
                stringBuffer.append(X500RDN.escapeValue(((ASN1String)aSN1Object).getValue(), bl));
            } else {
                stringBuffer.append('#');
                stringBuffer.append(Utils.toHexString(Utils.toBytes(aSN1Object)));
            }
            stringBuffer.append('+');
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    public String toASCII() {
        return this.toString(true);
    }

    static String escapeValue(String string, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            CharSequence charSequence;
            char c = string.charAt(i);
            if (bl && c >= '\u0080') {
                charSequence = new StringBuffer();
                while (true) {
                    ((StringBuffer)charSequence).append(c);
                    if (i == string.length() || string.charAt(i + 1) < '\u0080') break;
                    c = string.charAt(++i);
                }
                String string2 = Utils.toHexString(Utils.toUTF8(((StringBuffer)charSequence).toString()));
                int n2 = string2.length();
                for (int j = 0; j < n2; j += 2) {
                    stringBuffer.append('\\');
                    stringBuffer.append(string2.charAt(j));
                    stringBuffer.append(string2.charAt(j + 1));
                }
                continue;
            }
            if (c < ' ' || c == '\u007f' || i == 0 && c == ' ' || i == string.length() - 1 && c == ' ') {
                charSequence = Integer.toString(c, 16);
                stringBuffer.append('\\');
                if (c < '\u0010') {
                    stringBuffer.append('0');
                }
                stringBuffer.append((String)charSequence);
                continue;
            }
            if (c == ',' || c == '+' || c == '\"' || c == '\\' || c == '<' || c == '>' || c == ';' || i == 0 && c == '#') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static String unescapeValue(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == '\\' && i < string.length() - 1) {
                stringBuffer.append(string.charAt(++i));
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    static ASN1ObjectID getTypeID(String string) {
        return OIDManager.getOIDManager().getAttributeType(string);
    }

    private static String getTypeName(ASN1ObjectID aSN1ObjectID) {
        return OIDManager.getOIDManager().getAttributeName(aSN1ObjectID);
    }

    private static boolean isAlpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isHexChar(char c) {
        return X500RDN.isDigit(c) || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static boolean isSpecial(char c) {
        return c == ',' || c == '=' || c == '+' || c == '<' || c == '>' || c == '#' || c == ';';
    }

    static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    static boolean isASN1Printable(char c) {
        return X500RDN.isAlpha(c) || X500RDN.isDigit(c) || c == ' ' || c == '\'' || c == '(' || c == ')' || c == '+' || c == ',' || c == '-' || c == '.' || c == '/' || c == ':' || c == '=' || c == '?';
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.contents = null;
        this.attrSet = new Hashtable();
        ASN1SetInputStream aSN1SetInputStream = new ASN1SetInputStream(inputStream);
        while (aSN1SetInputStream.hasMoreData()) {
            AttributeTypeAndValue attributeTypeAndValue = new AttributeTypeAndValue(aSN1SetInputStream);
            if (attributeTypeAndValue == null) continue;
            this.attrSet.put(attributeTypeAndValue.getType(), attributeTypeAndValue);
        }
        aSN1SetInputStream.terminate();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Set().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1Set().length();
    }

    private ASN1Set toASN1Set() {
        if (this.contents == null) {
            ASN1Set aSN1Set = new ASN1Set();
            Enumeration enumeration = this.attrSet.elements();
            while (enumeration.hasMoreElements()) {
                aSN1Set.addElement((AttributeTypeAndValue)enumeration.nextElement());
            }
            this.contents = aSN1Set;
        }
        return this.contents;
    }

    private void input(String string) {
        this.contents = null;
        this.attrSet = new Hashtable();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '+' && !bl && n > 0 && string.charAt(n - 1) != '\\') {
                bl2 = true;
            } else if (c == '\"') {
                bl = !bl;
                stringBuffer.append(c);
            } else {
                stringBuffer.append(c);
            }
            if (!bl2 && ++n != string.length()) continue;
            this.parseAttribute(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            bl = false;
            bl2 = false;
        }
    }

    private void parseAttribute(String string) {
        String string2;
        int n;
        int n2 = 0;
        n2 = string.indexOf("=");
        if (n2 == -1) {
            throw new InvalidFormatException("'=' missing in attribute");
        }
        for (n = 0; n < n2 && X500RDN.isWhitespace(string.charAt(n)); ++n) {
        }
        if (n == n2) {
            throw new InvalidFormatException("Attribute type missing");
        }
        int n3 = n2 - 1;
        while (n3 >= 0 & X500RDN.isWhitespace(string.charAt(n3))) {
            --n3;
        }
        CharSequence charSequence = string.substring(n, n3 + 1);
        ASN1ObjectID aSN1ObjectID = X500RDN.isDigit(((String)charSequence).charAt(0)) ? new ASN1ObjectID((String)charSequence) : (((String)charSequence).toUpperCase().startsWith("OID.") ? new ASN1ObjectID(((String)charSequence).substring(4)) : X500RDN.getTypeID((String)charSequence));
        if (aSN1ObjectID == null) {
            throw new InvalidFormatException("Malformed attribute type");
        }
        ++n2;
        while (n2 < string.length() && X500RDN.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        n = string.length() - 1;
        while (X500RDN.isWhitespace(string.charAt(n))) {
            --n;
        }
        String string3 = string2 = n >= n2 ? string.substring(n2, n + 1) : "";
        if (string2.startsWith("#") && string2.length() > 1) {
            try {
                this.addAttribute(aSN1ObjectID, ASN1Utils.inputASN1Object(Utils.fromHexString(string2.substring(1))));
            }
            catch (IOException iOException) {
                throw new InvalidFormatException("Malformed attribute value string");
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidFormatException("Malformed attribute value string");
            }
        }
        if (string2.startsWith("\"")) {
            if (string2.length() == 1 || !string2.endsWith("\"")) {
                throw new InvalidFormatException("Missing final '\"'");
            }
            string2 = string2.substring(1, string2.length() - 1);
        }
        charSequence = new StringBuffer(string2.length());
        int n4 = string2.length();
        for (n2 = 0; n2 < n4; ++n2) {
            char c = string2.charAt(n2);
            if (c == '\\') {
                try {
                    if (X500RDN.isHexChar(string2.charAt(n2 + 1))) {
                        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
                        while (true) {
                            unsyncByteArrayOutputStream.write(Integer.parseInt(string2.substring(n2 + 1, n2 + 3), 16));
                            if ((n2 += 2) >= string2.length() - 1 || string2.charAt(n2 + 1) != '\\' || !X500RDN.isHexChar(string2.charAt(n2 + 2))) break;
                            ++n2;
                        }
                        ((StringBuffer)charSequence).append(Utils.fromUTF8(unsyncByteArrayOutputStream.toByteArray()));
                        continue;
                    }
                    if (X500RDN.isSpecial(c = string2.charAt(++n2)) || c == '\\' || c == '\"') {
                        ((StringBuffer)charSequence).append(c);
                        continue;
                    }
                    throw new IllegalArgumentException("Malformed attribute value string");
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IllegalArgumentException("Malformed attribute value string");
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Malformed attribute value string");
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.toString());
                }
            }
            ((StringBuffer)charSequence).append(c);
        }
        this.addAttribute(aSN1ObjectID, ((StringBuffer)charSequence).toString());
    }
}

