/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1String;
import com.phaos.cert.Entity;
import com.phaos.cert.PKIX;
import com.phaos.cert.X500RDN;
import com.phaos.utils.ArrayVector;
import com.phaos.utils.InvalidFormatException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class X500Name
extends Entity
implements ASN1Object,
Externalizable {
    private Vector rdnSequence = new Vector();
    private String countryName = null;
    private String stateName = null;
    private String localityName = null;
    private String organizationName = null;
    private String orgUnitName = null;
    private String email = null;
    private ASN1Sequence contents;
    private String stringContents;
    private int hash = -1;

    public X500Name() {
    }

    public X500Name(String string) {
        this.input(string);
    }

    public X500Name(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    X500Name(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(aSN1Sequence);
    }

    public void addComponent(X500RDN x500RDN) {
        this.rdnSequence.addElement(x500RDN);
        Enumeration enumeration = x500RDN.types();
        while (enumeration.hasMoreElements()) {
            ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)enumeration.nextElement();
            ASN1Object aSN1Object = x500RDN.getValue(aSN1ObjectID);
            if (!(aSN1Object instanceof ASN1String)) continue;
            ASN1String aSN1String = (ASN1String)aSN1Object;
            if (aSN1ObjectID.equals(PKIX.id_at_commonName)) {
                this.setName(aSN1String.getValue());
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.id_at_countryName)) {
                this.countryName = aSN1String.getValue();
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.id_at_localityName)) {
                this.localityName = aSN1String.getValue();
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.id_at_stateOrProvinceName)) {
                this.stateName = aSN1String.getValue();
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.id_at_organizationName)) {
                this.organizationName = aSN1String.getValue();
                continue;
            }
            if (aSN1ObjectID.equals(PKIX.id_at_organizationalUnitName)) {
                this.orgUnitName = aSN1String.getValue();
                continue;
            }
            if (!aSN1ObjectID.equals(PKIX.emailAddress)) continue;
            this.email = aSN1String.getValue();
        }
        this.stringContents = null;
        this.contents = null;
        this.hash = -1;
    }

    public void addComponent(ASN1ObjectID aSN1ObjectID, ASN1String aSN1String) {
        this.addComponent(new X500RDN(aSN1ObjectID, aSN1String));
    }

    public void addComponent(ASN1ObjectID aSN1ObjectID, String string) {
        this.addComponent(new X500RDN(aSN1ObjectID, string));
    }

    public void addComponent(String string, String string2) {
        this.addComponent(X500RDN.getTypeID(string), string2);
    }

    public ASN1Object getAttributeValue(String string) {
        return this.getAttributeValue(X500RDN.getTypeID(string));
    }

    public ASN1Object getAttributeValue(ASN1ObjectID aSN1ObjectID) {
        X500RDN x500RDN = this.getAttribute(aSN1ObjectID);
        return x500RDN != null ? x500RDN.getValue(aSN1ObjectID) : null;
    }

    public X500RDN getAttribute(String string) {
        ASN1ObjectID aSN1ObjectID = X500RDN.getTypeID(string);
        return aSN1ObjectID != null ? this.getAttribute(aSN1ObjectID) : null;
    }

    public X500RDN getAttribute(ASN1ObjectID aSN1ObjectID) {
        Enumeration enumeration = this.components();
        while (enumeration.hasMoreElements()) {
            X500RDN x500RDN = (X500RDN)enumeration.nextElement();
            if (x500RDN == null || x500RDN.getValue(aSN1ObjectID) == null) continue;
            return x500RDN;
        }
        return null;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.reset();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        while (aSN1SequenceInputStream.hasMoreData()) {
            this.addComponent(new X500RDN(aSN1SequenceInputStream));
        }
        aSN1SequenceInputStream.terminate();
    }

    void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    public void input(String string) throws InvalidFormatException {
        this.reset();
        boolean bl = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (X500RDN.isWhitespace(string.charAt(i))) continue;
            bl = false;
            break;
        }
        if (bl) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        n = 0;
        boolean bl2 = false;
        int n2 = 0;
        ArrayVector arrayVector = new ArrayVector();
        while (n2 < string.length()) {
            try {
                char c = string.charAt(n2);
                if (c == '\"') {
                    n = n == 0 ? 1 : 0;
                    stringBuffer.append(c);
                } else if (c == ',' || c == ';') {
                    if (n != 0) {
                        stringBuffer.append(c);
                    } else {
                        bl2 = true;
                    }
                } else if (c == '\\') {
                    stringBuffer.append(c);
                    c = string.charAt(++n2);
                    stringBuffer.append(c);
                } else {
                    stringBuffer.append(c);
                }
                if (!bl2 && ++n2 != string.length()) continue;
                arrayVector.addElement(new X500RDN(stringBuffer.toString()));
                stringBuffer = new StringBuffer();
                n = 0;
                bl2 = false;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new InvalidFormatException("Malformed DN string");
            }
        }
        Object[] objectArray = new X500RDN[arrayVector.size()];
        arrayVector.getElements(objectArray);
        for (int i = objectArray.length - 1; i >= 0; --i) {
            this.addComponent((X500RDN)objectArray[i]);
        }
    }

    private void reset() {
        this.rdnSequence.removeAllElements();
        this.countryName = null;
        this.stateName = null;
        this.localityName = null;
        this.organizationName = null;
        this.orgUnitName = null;
        this.email = null;
        this.stringContents = null;
        this.contents = null;
        this.hash = -1;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    ASN1Sequence outputASN1() {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                aSN1Sequence.addElement((X500RDN)this.rdnSequence.elementAt(i));
            }
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    public String toString() {
        if (this.stringContents == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = this.size() - 1; i >= 0; --i) {
                X500RDN x500RDN = this.componentAt(i);
                stringBuffer.append(x500RDN.toString());
                stringBuffer.append(',');
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            this.stringContents = stringBuffer.toString();
        }
        return this.stringContents;
    }

    public Vector getComponents() {
        if (this.rdnSequence == null) {
            this.rdnSequence = new Vector();
            if (this.countryName != null) {
                this.rdnSequence.addElement(new X500RDN(PKIX.id_at_countryName, this.countryName));
            }
            if (this.stateName != null) {
                this.rdnSequence.addElement(new X500RDN(PKIX.id_at_stateOrProvinceName, this.stateName));
            }
            if (this.localityName != null) {
                this.rdnSequence.addElement(new X500RDN(PKIX.id_at_localityName, this.localityName));
            }
            if (this.organizationName != null) {
                this.rdnSequence.addElement(new X500RDN(PKIX.id_at_organizationName, this.organizationName));
            }
            if (this.orgUnitName != null) {
                this.rdnSequence.addElement(new X500RDN(PKIX.id_at_organizationalUnitName, this.orgUnitName));
            }
            if (this.getName() != null) {
                this.rdnSequence.addElement(new X500RDN(PKIX.id_at_commonName, this.getName()));
            }
            if (this.email != null) {
                this.rdnSequence.addElement(new X500RDN(PKIX.emailAddress, this.email));
            }
        }
        return this.rdnSequence;
    }

    public Enumeration components() {
        return this.getComponents().elements();
    }

    public int size() {
        return this.getComponents().size();
    }

    public X500RDN componentAt(int n) {
        return (X500RDN)this.getComponents().elementAt(n);
    }

    private void clearNewAPI() {
        this.rdnSequence = null;
        this.contents = null;
        this.stringContents = null;
        this.hash = -1;
    }

    public String getCountryName() {
        return this.countryName;
    }

    public void setCountryName(String string) {
        this.countryName = string;
        this.clearNewAPI();
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String string) {
        this.stateName = string;
        this.clearNewAPI();
    }

    public String getLocalityName() {
        return this.localityName;
    }

    public void setLocalityName(String string) {
        this.localityName = string;
        this.clearNewAPI();
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String string) {
        this.organizationName = string;
        this.clearNewAPI();
    }

    public String getOrgUnitName() {
        return this.orgUnitName;
    }

    public void setOrgUnitName(String string) {
        this.orgUnitName = string;
        this.clearNewAPI();
    }

    public String getCommonName() {
        return this.getName();
    }

    public void setCommonName(String string) {
        this.setName(string);
        this.clearNewAPI();
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String string) {
        this.email = string;
        this.clearNewAPI();
    }

    public void setAttr(String string, String string2) {
        if (string.equalsIgnoreCase("C")) {
            this.setCountryName(string2);
        } else if (string.equalsIgnoreCase("ST")) {
            this.setStateName(string2);
        } else if (string.equalsIgnoreCase("L")) {
            this.setLocalityName(string2);
        } else if (string.equalsIgnoreCase("O")) {
            this.setOrganizationName(string2);
        } else if (string.equalsIgnoreCase("OU")) {
            this.setOrgUnitName(string2);
        } else if (string.equalsIgnoreCase("CN")) {
            this.setName(string2);
        } else if (string.equalsIgnoreCase("Email")) {
            this.setEmail(string2);
        } else {
            throw new IllegalArgumentException("Attribute '" + string + "' cannot be set using setAttr(String, String)" + ", only {C, ST, L, O, OU, CN, EMAIL} are allowed.");
        }
    }

    public void forgetOriginalFormat() {
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        X500Name x500Name = (X500Name)object;
        if (x500Name.size() != this.size()) {
            return false;
        }
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.componentAt(i).equals(x500Name.componentAt(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = this.toString().hashCode();
        }
        return this.hash;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.outputASN1().getEncoded());
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray = (byte[])objectInput.readObject();
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

