/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1String;
import com.phaos.crypto.KeyPair;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.SignatureException;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.FixedByteArrayOutputStream;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SPKAC
implements ASN1Object {
    private PublicKey pubKey;
    private String challenge;
    private PrivateKey privKey;
    private ASN1Sequence contents;
    private transient RandomBitsSource rbs;

    public SPKAC() {
    }

    public SPKAC(KeyPair keyPair) {
        this(keyPair, RandomBitsSource.getDefault());
    }

    public SPKAC(KeyPair keyPair, RandomBitsSource randomBitsSource) {
        this("", keyPair, randomBitsSource);
    }

    public SPKAC(String string, KeyPair keyPair) {
        this(string, keyPair, RandomBitsSource.getDefault());
    }

    public SPKAC(String string, KeyPair keyPair, RandomBitsSource randomBitsSource) {
        this.pubKey = keyPair.getPublic();
        this.privKey = keyPair.getPrivate();
        this.challenge = string;
    }

    public SPKAC(String string) {
        this.challenge = string;
    }

    public SPKAC(InputStream inputStream) throws IOException {
        this();
        this.input(inputStream);
    }

    public SPKAC(String string, InputStream inputStream) throws IOException {
        this(string);
        this.input(inputStream);
    }

    public SPKAC(String string, String string2) throws IOException {
        this(string);
        this.input(string2);
    }

    public PublicKey getPublicKey() {
        return this.pubKey;
    }

    public String getChallenge() {
        return this.challenge;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(CryptoUtils.subjectPublicKeyInfo(this.pubKey));
        aSN1Sequence.addElement(new ASN1String(this.challenge, 22));
        try {
            this.contents = CryptoUtils.signASN1(aSN1Sequence, this.privKey, this.rbs);
        }
        catch (SignatureException signatureException) {
            throw new StreamableOutputException(signatureException.toString());
        }
        return this.contents;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.contents = aSN1Sequence;
        String string = null;
        try {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.elementAt(0);
            this.pubKey = CryptoUtils.inputSPKI((ASN1Sequence)aSN1Sequence2.elementAt(0));
            string = ((ASN1String)aSN1Sequence2.elementAt(1)).getValue();
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        if (this.challenge == null) {
            this.challenge = string;
        } else if (!this.challenge.equals(string)) {
            throw new IOException("Challenge does not equal the expected value");
        }
        if (!CryptoUtils.verifySignedASN1(aSN1Sequence, this.pubKey)) {
            throw new IOException("Invalid signature");
        }
    }

    public void input(String string) throws IOException {
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(Utils.fromBase64(string));
        this.input(unsyncByteArrayInputStream);
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    public String toBase64() throws IOException {
        FixedByteArrayOutputStream fixedByteArrayOutputStream = new FixedByteArrayOutputStream(this.length());
        this.output(fixedByteArrayOutputStream);
        return Utils.toBase64(fixedByteArrayOutputStream.getBytes());
    }
}

