/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Constructed;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Set;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.CRL;
import com.phaos.cert.X500Name;
import com.phaos.cert.X509;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RSAPublicKey;
import com.phaos.crypto.Signature;
import com.phaos.crypto.SignatureException;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;

public class PKCS7
implements ASN1Object {
    private Vector certificates;
    private Vector crls;
    private X500Name issuer;
    private BigInteger serialNo;
    private RSAPublicKey pubKey;
    private Signature sig;
    private byte[] aaBytes;
    private byte[] hashBytes;
    private byte[] docHash;
    private byte[] sigBytes;
    private AlgorithmIdentifier mdAlg;
    private ASN1Sequence contents;
    protected static final int[] pkcs7 = new int[]{1, 2, 840, 113549, 1, 7};

    public PKCS7() {
    }

    public PKCS7(Vector vector, Vector vector2) {
        this.certificates = vector;
        this.crls = vector2;
    }

    public PKCS7(X509 x509) {
        this.certificates = new Vector();
        this.certificates.addElement(x509);
    }

    public PKCS7(CRL cRL) {
        this.crls = new Vector();
        this.crls.addElement(this.crls);
    }

    public PKCS7(X509 x509, RSAPrivateKey rSAPrivateKey, byte[] byArray) throws SignatureException {
        this();
        this.sign(x509, rSAPrivateKey, byArray);
    }

    public PKCS7(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public PKCS7(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(aSN1Sequence);
    }

    public Vector getCertificates() {
        return this.certificates;
    }

    public Vector getCRLs() {
        return this.crls;
    }

    public void addCertificate(X509 x509) {
        if (this.certificates == null) {
            this.certificates = new Vector();
        }
        this.certificates.addElement(x509);
    }

    public void addCRL(CRL cRL) {
        if (this.crls == null) {
            this.crls = new Vector();
        }
        this.crls.addElement(cRL);
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerialNo() {
        return this.serialNo;
    }

    public void setPublicKey(RSAPublicKey rSAPublicKey) {
        this.pubKey = rSAPublicKey;
        if (this.aaBytes != null) {
            try {
                this.sig = Signature.getInstance(PKCS7.getSigAlgID(this.mdAlg));
                this.sig.setPublicKey(this.pubKey);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IllegalStateException(algorithmIdentifierException.toString());
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IllegalStateException(invalidKeyException.toString());
            }
            this.sig.setDocument(this.aaBytes);
            this.sig.setSigBytes(this.sigBytes);
        }
    }

    public void setSigner(X509 x509) {
        if (this.issuer == null) {
            this.issuer = x509.getIssuer();
        } else if (!this.issuer.equals(x509.getIssuer())) {
            throw new RuntimeException("The issuer is " + this.issuer + ", which is not " + x509.getIssuer());
        }
        if (this.serialNo == null) {
            this.serialNo = x509.getSerialNo();
        } else if (!this.serialNo.equals(x509.getSerialNo())) {
            throw new RuntimeException("The serial number is " + this.serialNo + ", which is not " + x509.getSerialNo());
        }
        this.setPublicKey((RSAPublicKey)x509.getPublicKey());
    }

    public void setDocument(byte[] byArray) {
        if (this.pubKey == null) {
            throw new IllegalStateException("The public key is not set");
        }
        if (this.aaBytes == null) {
            try {
                this.sig = Signature.getInstance(PKCS7.getSigAlgID(this.mdAlg));
                this.sig.setPublicKey(this.pubKey);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IllegalStateException(algorithmIdentifierException.toString());
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IllegalStateException(invalidKeyException.toString());
            }
            this.sig.setDocument(byArray);
            this.sig.setSigBytes(this.sigBytes);
        } else {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(this.mdAlg);
                messageDigest.update(byArray);
                messageDigest.computeCurrent();
                this.docHash = messageDigest.digestBits;
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IllegalStateException(algorithmIdentifierException.toString());
            }
        }
    }

    public void sign(X509 x509, RSAPrivateKey rSAPrivateKey, byte[] byArray) throws SignatureException {
        this.issuer = x509.getIssuer();
        this.serialNo = x509.getSerialNo();
        if (!x509.getPublicKey().getAlgorithm().equals("RSA")) {
            throw new SignatureException("Only RSA signatures are supported");
        }
        this.pubKey = (RSAPublicKey)x509.getPublicKey();
        this.sig = Signature.getInstance(rSAPrivateKey);
        this.mdAlg = PKCS7.getDigestAlgID(this.sig.getAlgID());
        this.sig.setDocument(byArray);
        this.sig.sign();
        this.sigBytes = this.sig.getSigBytes();
    }

    public void sign(X509 x509, RSAPrivateKey rSAPrivateKey, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws SignatureException {
        this.issuer = x509.getIssuer();
        this.serialNo = x509.getSerialNo();
        if (!x509.getPublicKey().getAlgorithm().equals("RSA")) {
            throw new SignatureException("Only RSA signatures are supported");
        }
        this.pubKey = (RSAPublicKey)x509.getPublicKey();
        this.mdAlg = PKCS7.getDigestAlgID(algorithmIdentifier);
        try {
            this.sig = Signature.getInstance(algorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new SignatureException(algorithmIdentifierException.toString());
        }
        try {
            this.sig.setPrivateKey(rSAPrivateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException.toString());
        }
        this.sig.setDocument(byArray);
        this.sig.sign();
        this.sigBytes = this.sig.getSigBytes();
    }

    public boolean verify() throws AuthenticationException {
        if (this.aaBytes == null) {
            return this.sig.verify();
        }
        return this.sig.verify() && MessageDigest.isEqual(this.docHash, this.hashBytes);
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1ObjectID(pkcs7, 2));
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        aSN1Sequence2.addElement(new ASN1Integer(1L));
        aSN1Sequence2.addElement(new ASN1Set());
        ASN1Sequence aSN1Sequence3 = new ASN1Sequence();
        aSN1Sequence3.addElement(new ASN1ObjectID(pkcs7, 1));
        aSN1Sequence2.addElement(aSN1Sequence3);
        if (this.certificates != null) {
            aSN1Sequence2.addElement(new ASN1GenericConstructed(this.certificates, 0));
        }
        if (this.crls != null) {
            aSN1Sequence2.addElement(new ASN1GenericConstructed(this.crls, 1));
        }
        if (this.sig == null) {
            aSN1Sequence2.addElement(new ASN1Set());
        } else {
            aSN1Sequence3 = new ASN1Sequence();
            aSN1Sequence3.addElement(new ASN1Integer(1L));
            ASN1Sequence aSN1Sequence4 = new ASN1Sequence();
            aSN1Sequence4.addElement(this.issuer);
            aSN1Sequence4.addElement(new ASN1Integer(this.serialNo));
            aSN1Sequence3.addElement(aSN1Sequence4);
            aSN1Sequence3.addElement(this.mdAlg);
            aSN1Sequence3.addElement(AlgID.rsaEncryption);
            aSN1Sequence3.addElement(new ASN1OctetString(this.sigBytes));
            aSN1Sequence2.addElement(new ASN1Set(aSN1Sequence3));
        }
        aSN1Sequence.addElement(new ASN1GenericConstructed(aSN1Sequence2, 0));
        this.contents = aSN1Sequence;
        return aSN1Sequence;
    }

    private static AlgorithmIdentifier getDigestAlgID(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier.getOID().equals(AlgID.md2WithRSAEncryption.getOID())) {
            return AlgID.md2;
        }
        if (algorithmIdentifier.getOID().equals(AlgID.md5WithRSAEncryption.getOID())) {
            return AlgID.md5;
        }
        if (algorithmIdentifier.getOID().equals(AlgID.sha_1WithRSAEncryption.getOID())) {
            return AlgID.sha_1;
        }
        throw new IllegalStateException("Unsupported signature algorithm identifier");
    }

    private static AlgorithmIdentifier getSigAlgID(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier.getOID().equals(AlgID.md2.getOID())) {
            return AlgID.md2WithRSAEncryption;
        }
        if (algorithmIdentifier.getOID().equals(AlgID.md5.getOID())) {
            return AlgID.md5WithRSAEncryption;
        }
        if (algorithmIdentifier.getOID().equals(AlgID.sha_1.getOID()) || algorithmIdentifier.getOID().equals(AlgID.sha.getOID())) {
            return AlgID.sha_1WithRSAEncryption;
        }
        throw new IllegalStateException("Unsupported message digest algorithm identifier");
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        try {
            ASN1Constructed aSN1Constructed;
            this.contents = aSN1Sequence;
            ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)aSN1Sequence.elementAt(0);
            if (!aSN1ObjectID.equals(pkcs7, 2)) {
                throw new IOException("contentType has to be signedData");
            }
            if (aSN1Sequence.elements().size() < 2) {
                throw new IOException("No content");
            }
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)((ASN1GenericConstructed)aSN1Sequence.elementAt(1)).elementAt(0);
            this.certificates = null;
            this.crls = null;
            int n = 3;
            while (!(aSN1Sequence2.elementAt(n) instanceof ASN1Set)) {
                aSN1Constructed = (ASN1GenericConstructed)aSN1Sequence2.elementAt(n);
                switch (((ASN1GenericConstructed)aSN1Constructed).getTag()) {
                    case 0: {
                        int n2;
                        this.certificates = new Vector();
                        int n3 = ((ASN1GenericConstructed)aSN1Constructed).size();
                        for (n2 = 0; n2 < n3; ++n2) {
                            this.certificates.addElement(new X509(Utils.toStream(((ASN1GenericConstructed)aSN1Constructed).elementAt(n2))));
                        }
                        break;
                    }
                    case 1: {
                        int n2;
                        this.crls = new Vector();
                        int n3 = ((ASN1GenericConstructed)aSN1Constructed).size();
                        for (n2 = 0; n2 < n3; ++n2) {
                            this.crls.addElement(new CRL(Utils.toStream(((ASN1GenericConstructed)aSN1Constructed).elementAt(n2))));
                        }
                        break;
                    }
                }
                ++n;
            }
            aSN1Constructed = (ASN1Set)aSN1Sequence2.elementAt(n);
            if (((ASN1Set)aSN1Constructed).elements().size() > 0) {
                n = 0;
                ASN1Sequence aSN1Sequence3 = (ASN1Sequence)((ASN1Set)aSN1Constructed).elementAt(0);
                int n4 = ++n;
                ASN1TaggedObject aSN1TaggedObject = (ASN1Sequence)aSN1Sequence3.elementAt(n4);
                this.issuer = new X500Name((ASN1Sequence)((ASN1Sequence)aSN1TaggedObject).elementAt(0));
                this.serialNo = ((ASN1Integer)((ASN1Sequence)aSN1TaggedObject).elementAt(1)).getValue();
                int n5 = ++n;
                this.mdAlg = new AlgorithmIdentifier(Utils.toStream((ASN1Sequence)aSN1Sequence3.elementAt(n5)));
                if (aSN1Sequence3.elementAt(++n) instanceof ASN1GenericConstructed) {
                    aSN1TaggedObject = new ASN1Set(((ASN1GenericConstructed)aSN1Sequence3.elementAt(n++)).elements());
                    this.aaBytes = Utils.toBytes(aSN1TaggedObject);
                    this.hashBytes = null;
                    Vector vector = ((ASN1Set)aSN1TaggedObject).elements();
                    int n6 = vector.size();
                    for (int i = 0; i < n6; ++i) {
                        ASN1Sequence aSN1Sequence4 = (ASN1Sequence)vector.elementAt(i);
                        ASN1ObjectID aSN1ObjectID2 = (ASN1ObjectID)aSN1Sequence4.elementAt(0);
                        if (!aSN1ObjectID2.equals(ASN1Utils.pkcsID, 9, 4)) continue;
                        this.hashBytes = ((ASN1OctetString)((ASN1Set)aSN1Sequence4.elementAt(1)).elementAt(0)).getValue();
                    }
                    if (this.hashBytes == null) {
                        throw new IOException("No message digest found in authenticatedAttributes");
                    }
                }
                if (!((ASN1ObjectID)(aSN1TaggedObject = (ASN1ObjectID)((ASN1Sequence)aSN1Sequence3.elementAt(n++)).elementAt(0))).equals(AlgID.rsaEncryption.getOID())) {
                    throw new IOException("Unsupported encryption algorithm " + aSN1TaggedObject);
                }
                this.sigBytes = ((ASN1OctetString)aSN1Sequence3.elementAt(n++)).getValue();
            }
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    public byte[] getEncoded() {
        return this.outputASN1().getEncoded();
    }
}

