/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Set;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.PKCS12Bag;
import com.phaos.cert.PKCS12Safe;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PrivateKeyPKCS8;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PKCS12ShroudedKeyBag
extends PKCS12Bag {
    private PKCS12Safe parent;
    private String passwd;
    private PrivateKeyPKCS8 pkcs8;
    private ASN1Sequence contents;

    public PKCS12ShroudedKeyBag(PKCS12Safe pKCS12Safe) {
        this.parent = pKCS12Safe;
    }

    public PKCS12ShroudedKeyBag(PKCS12Safe pKCS12Safe, PrivateKeyPKCS8 privateKeyPKCS8) {
        this(pKCS12Safe);
        this.pkcs8 = privateKeyPKCS8;
    }

    public PKCS12ShroudedKeyBag(PKCS12Safe pKCS12Safe, InputStream inputStream) throws IOException {
        this(pKCS12Safe);
        this.input(inputStream);
    }

    public PKCS12ShroudedKeyBag(PKCS12Safe pKCS12Safe, ASN1Sequence aSN1Sequence) throws IOException {
        this(pKCS12Safe);
        this.input(aSN1Sequence);
    }

    @Override
    void reset() {
        this.contents = null;
        if (this.parent != null) {
            this.parent.reset();
        }
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)aSN1Sequence.elementAt(1);
        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1GenericConstructed.elementAt(0);
        this.pkcs8 = new PrivateKeyPKCS8(aSN1Sequence2);
        this.reset();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        try {
            this.toASN1().output(outputStream);
        }
        catch (StreamableOutputException streamableOutputException) {
            throw new IOException(streamableOutputException.toString());
        }
    }

    private ASN1Sequence toASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = null;
        try {
            aSN1Sequence = (ASN1Sequence)this.pkcs8.getContents();
        }
        catch (StreamableOutputException streamableOutputException) {
            this.pkcs8.setPassword(this.getPassword());
            aSN1Sequence = (ASN1Sequence)this.pkcs8.getContents();
        }
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        aSN1Sequence2.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 2));
        aSN1Sequence2.addElement(new ASN1GenericConstructed(aSN1Sequence, 0));
        ASN1Set aSN1Set = this.outputAttrsASN1();
        if (aSN1Set != null) {
            aSN1Sequence2.addElement(aSN1Set);
        }
        this.contents = aSN1Sequence2;
        return aSN1Sequence2;
    }

    @Override
    public int length() {
        return this.toASN1().length();
    }

    public void setPassword(String string) {
        this.passwd = string;
        this.reset();
    }

    public String getPassword() {
        return this.passwd != null ? this.passwd : this.parent.getPassword();
    }

    public PrivateKey getPrivateKey() {
        if (this.pkcs8 == null) {
            return null;
        }
        this.pkcs8.setPassword(this.getPassword());
        return this.pkcs8.getKey();
    }

    public PrivateKeyPKCS8 getPKCS8() {
        return this.pkcs8;
    }

    public void setPKCS8(PrivateKeyPKCS8 privateKeyPKCS8) {
        this.pkcs8 = privateKeyPKCS8;
        this.reset();
    }

    public String toString() {
        String string = "";
        if (this.friendlyName != null) {
            string = string + "friendlyName = \"" + this.friendlyName + "\", ";
        }
        if (this.localKeyID != null) {
            string = string + "localKeyID = " + Utils.toHexString(this.localKeyID) + ", ";
        }
        return string + this.pkcs8.toString();
    }
}

