/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Constructed;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.PKCS12Bag;
import com.phaos.cert.PKCS12Safe;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class PKCS12SafeContentsBag
extends PKCS12Bag {
    private PKCS12Safe parent;
    private Vector bags;
    private ASN1Sequence contents;

    public PKCS12SafeContentsBag(PKCS12Safe pKCS12Safe) {
        this.parent = pKCS12Safe;
    }

    public PKCS12SafeContentsBag(PKCS12Safe pKCS12Safe, Vector vector) {
        this(pKCS12Safe);
        this.bags = vector;
    }

    public PKCS12SafeContentsBag(PKCS12Safe pKCS12Safe, InputStream inputStream) throws IOException {
        this(pKCS12Safe);
        this.input(inputStream);
    }

    public PKCS12SafeContentsBag(PKCS12Safe pKCS12Safe, ASN1Sequence aSN1Sequence) throws IOException {
        this(pKCS12Safe);
        this.input(aSN1Sequence);
    }

    @Override
    void reset() {
        this.contents = null;
        if (this.parent != null) {
            this.parent.reset();
        }
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        try {
            ASN1GenericConstructed aSN1GenericConstructed = (ASN1GenericConstructed)aSN1Sequence.elementAt(1);
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1GenericConstructed.elementAt(0);
            this.bags = new Vector();
            int n = aSN1Sequence2.size();
            for (int i = 0; i < n; ++i) {
                this.bags.addElement(PKCS12Bag.inputBag(null, (ASN1Sequence)aSN1Sequence2.elementAt(i)));
            }
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
        this.reset();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 6));
        ASN1Constructed aSN1Constructed = new ASN1Sequence(this.bags);
        aSN1Sequence.addElement(new ASN1GenericConstructed(aSN1Constructed, 0));
        aSN1Constructed = this.outputAttrsASN1();
        if (aSN1Constructed != null) {
            aSN1Sequence.addElement(aSN1Constructed);
        }
        this.contents = aSN1Sequence;
        return aSN1Sequence;
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    public Vector getBags() {
        return this.bags;
    }

    public void setBags(Vector vector) {
        this.bags = vector;
        this.reset();
    }

    public void addBag(PKCS12Bag pKCS12Bag) {
        if (this.bags == null) {
            this.bags = new Vector();
        }
        this.bags.addElement(pKCS12Bag);
        this.reset();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.friendlyName != null) {
            stringBuffer.append("friendlyName = \"" + this.friendlyName + "\", ");
        }
        if (this.localKeyID != null) {
            stringBuffer.append("localKeyID = " + Utils.toHexString(this.localKeyID) + ", ");
        }
        stringBuffer.append("bags = {");
        int n = this.bags.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.bags.elementAt(i).toString());
            if (i == n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

