/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Set;
import com.phaos.ASN1.ASN1String;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.PKCS12CRLBag;
import com.phaos.cert.PKCS12CertBag;
import com.phaos.cert.PKCS12KeyBag;
import com.phaos.cert.PKCS12Safe;
import com.phaos.cert.PKCS12SafeContentsBag;
import com.phaos.cert.PKCS12SecretBag;
import com.phaos.cert.PKCS12ShroudedKeyBag;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public abstract class PKCS12Bag
implements ASN1Object {
    String friendlyName;
    byte[] localKeyID;

    protected PKCS12Bag() {
    }

    public static PKCS12Bag inputBag(PKCS12Safe pKCS12Safe, InputStream inputStream) throws IOException {
        return PKCS12Bag.inputBag(pKCS12Safe, new ASN1Sequence(inputStream));
    }

    static PKCS12Bag inputBag(PKCS12Safe pKCS12Safe, ASN1Sequence aSN1Sequence) throws IOException {
        try {
            ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)aSN1Sequence.elementAt(0);
            PKCS12Bag pKCS12Bag = null;
            if (aSN1ObjectID.equals(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 1))) {
                pKCS12Bag = new PKCS12KeyBag(pKCS12Safe, aSN1Sequence);
            } else if (aSN1ObjectID.equals(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 2))) {
                pKCS12Bag = new PKCS12ShroudedKeyBag(pKCS12Safe, aSN1Sequence);
            } else if (aSN1ObjectID.equals(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 3))) {
                pKCS12Bag = new PKCS12CertBag(pKCS12Safe, aSN1Sequence);
            } else if (aSN1ObjectID.equals(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 4))) {
                pKCS12Bag = new PKCS12CRLBag(pKCS12Safe, aSN1Sequence);
            } else if (aSN1ObjectID.equals(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 5))) {
                pKCS12Bag = new PKCS12SecretBag(pKCS12Safe, aSN1Sequence);
            } else if (aSN1ObjectID.equals(new ASN1ObjectID(ASN1Utils.pkcsID, 12, 10, 1, 6))) {
                pKCS12Bag = new PKCS12SafeContentsBag(pKCS12Safe, aSN1Sequence);
            } else {
                throw new IOException("Unknown PKCS#12 bag type: " + aSN1ObjectID);
            }
            if (aSN1Sequence.size() > 2) {
                ASN1Set aSN1Set = (ASN1Set)aSN1Sequence.elementAt(2);
                Vector vector = aSN1Set.elements();
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    Object object;
                    ASN1Set aSN1Set2;
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)vector.elementAt(i);
                    ASN1ObjectID aSN1ObjectID2 = (ASN1ObjectID)aSN1Sequence2.elementAt(0);
                    if (aSN1ObjectID2.equals(ASN1Utils.pkcsID, 9, 20)) {
                        aSN1Set2 = (ASN1Set)aSN1Sequence2.elementAt(1);
                        object = ((ASN1String)aSN1Set2.elementAt(0)).getValue();
                        pKCS12Bag.setFriendlyName((String)object);
                        continue;
                    }
                    if (!aSN1ObjectID2.equals(ASN1Utils.pkcsID, 9, 21)) continue;
                    aSN1Set2 = (ASN1Set)aSN1Sequence2.elementAt(1);
                    object = ((ASN1OctetString)aSN1Set2.elementAt(0)).getValue();
                    pKCS12Bag.setLocalKeyID((byte[])object);
                }
            }
            return pKCS12Bag;
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    abstract void reset();

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String string) {
        this.friendlyName = string;
        this.reset();
    }

    public byte[] getLocalKeyID() {
        return this.localKeyID;
    }

    public void setLocalKeyID(byte[] byArray) {
        this.localKeyID = byArray;
        this.reset();
    }

    public ASN1Set outputAttrsASN1() {
        ASN1Set aSN1Set;
        ASN1Sequence aSN1Sequence;
        ASN1Set aSN1Set2 = new ASN1Set();
        if (this.friendlyName != null) {
            aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 9, 20));
            aSN1Set = new ASN1Set();
            aSN1Set.addElement(new ASN1String(this.friendlyName, 30));
            aSN1Sequence.addElement(aSN1Set);
            aSN1Set2.addElement(aSN1Sequence);
        }
        if (this.localKeyID != null) {
            aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1ObjectID(ASN1Utils.pkcsID, 9, 21));
            aSN1Set = new ASN1Set();
            aSN1Set.addElement(new ASN1OctetString(this.localKeyID));
            aSN1Sequence.addElement(aSN1Set);
            aSN1Set2.addElement(aSN1Sequence);
        }
        if (aSN1Set2.elements().size() > 0) {
            return aSN1Set2;
        }
        return null;
    }
}

