/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1String;
import com.phaos.cert.GeneralName;
import com.phaos.cert.X500Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class GeneralNames
implements ASN1Object {
    private Vector gns = new Vector();
    private ASN1Sequence contents;

    public GeneralNames() {
    }

    public GeneralNames(Vector vector) {
        this.addGeneralNames(vector);
    }

    public GeneralNames(GeneralName generalName) {
        this.addGeneralName(generalName);
    }

    public GeneralNames(X500Name x500Name) {
        this(x500Name, null);
    }

    public GeneralNames(String string) {
        this(null, string);
    }

    public GeneralNames(X500Name x500Name, String string) {
        if (x500Name != null) {
            this.addGeneralName(x500Name);
        }
        if (string != null) {
            this.addGeneralName(string);
        }
    }

    public GeneralNames(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void addGeneralName(X500Name x500Name) {
        if (x500Name != null) {
            this.addGeneralName(new GeneralName(x500Name));
        }
    }

    public void addGeneralName(String string) {
        if (string != null) {
            this.addGeneralName(new GeneralName(GeneralName.Type.RFC822_NAME, string));
        }
    }

    public void addGeneralName(GeneralName generalName) {
        if (generalName != null) {
            this.gns.addElement(generalName);
            this.clearContents();
        }
    }

    public void addGeneralNames(Vector vector) {
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                this.gns.addElement(vector.elementAt(i));
            }
            this.clearContents();
        }
    }

    public boolean removeGeneralName(X500Name x500Name) {
        if (x500Name != null) {
            return this.removeGeneralName(new GeneralName(x500Name));
        }
        return false;
    }

    public boolean removeGeneralName(String string) {
        if (string != null) {
            return this.removeGeneralName(new GeneralName(GeneralName.Type.RFC822_NAME, string));
        }
        return false;
    }

    public boolean removeGeneralName(GeneralName generalName) {
        boolean bl = false;
        if (generalName != null) {
            bl = this.gns.removeElement(generalName);
            if (bl) {
                // empty if block
            }
            this.clearContents();
        }
        return bl;
    }

    public GeneralName removeGeneralName(int n) {
        GeneralName generalName = (GeneralName)this.gns.elementAt(n);
        this.gns.removeElementAt(n);
        this.clearContents();
        return generalName;
    }

    public boolean removeGeneralNames(Vector vector) {
        boolean bl = false;
        if (vector != null && vector.size() != 0) {
            boolean bl2 = false;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                bl2 = this.gns.removeElement(vector.elementAt(i));
                if (bl) continue;
                bl = bl2;
            }
        }
        if (bl) {
            this.clearContents();
        }
        return bl;
    }

    public GeneralName generalNameAt(int n) {
        return (GeneralName)this.gns.elementAt(n);
    }

    public int size() {
        return this.gns.size();
    }

    public boolean containsGeneralName(GeneralName generalName) {
        if (generalName == null || this.gns == null || this.gns.size() < 1) {
            return false;
        }
        return this.gns.contains(generalName);
    }

    public String toString() {
        if (this.gns == null || this.gns.size() < 1) {
            return "General Names: 0 Elements\n";
        }
        StringBuffer stringBuffer = new StringBuffer("GeneralNames: " + this.gns.size() + " Elements\n");
        int n = this.gns.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(i + ". " + (GeneralName)this.gns.elementAt(i) + "\n");
        }
        return stringBuffer.toString();
    }

    public Vector getGeneralNames() {
        return this.gns;
    }

    public Enumeration generalNames() {
        if (this.gns == null) {
            return new Vector().elements();
        }
        return this.gns.elements();
    }

    public Vector getRFC822Names() {
        if (this.gns == null || this.gns.size() < 1) {
            return null;
        }
        Vector<String> vector = null;
        int n = this.gns.size();
        for (int i = 0; i < n; ++i) {
            GeneralName generalName = (GeneralName)this.gns.elementAt(i);
            if (!generalName.getType().equals(GeneralName.Type.RFC822_NAME)) continue;
            if (vector == null) {
                vector = new Vector<String>();
            }
            vector.addElement(((ASN1String)generalName.getValue()).getValue());
        }
        return vector;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.clearContents();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        if (aSN1SequenceInputStream.hasMoreData()) {
            this.gns = new Vector();
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.gns.addElement(new GeneralName(aSN1SequenceInputStream));
            }
        }
        aSN1SequenceInputStream.terminate();
        if (this.gns == null || this.gns.size() < 1) {
            throw new IOException("General Names can not be Empty");
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        if (this.gns == null || this.gns.size() < 1) {
            throw new IOException("General Names is Empty");
        }
        this.toASN1Sequence().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1Sequence().length();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            this.contents = new ASN1Sequence(this.gns);
        }
        return this.contents;
    }

    private void clearContents() {
        this.contents = null;
    }
}

