/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import java.io.Serializable;
import java.util.Date;

public class CertificateStatus
implements Serializable {
    public static final int UNKNOWN = 0;
    public static final int VALID = 1;
    public static final int INVALID = 2;
    public static final int REVOKED = 3;
    public static final int EXPIRED = 4;
    public static final int ON_HOLD = 5;
    protected static final String[] statusCodeStrs = new String[]{"UNKNOWN", "VALID", "INVALID", "REVOKED", "EXPIRED", "ON_HOLD"};
    protected int statusCode = 0;
    protected String reason;
    protected Date revocationDate;

    public CertificateStatus() {
    }

    public CertificateStatus(int n) {
        this.statusCode = n;
    }

    public CertificateStatus(int n, String string) {
        this(n);
        this.reason = string;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusCodeString() {
        if (this.statusCode >= 0 && this.statusCode < statusCodeStrs.length) {
            return statusCodeStrs[this.statusCode];
        }
        return "UNKNOWN";
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    public void setStatusCode(String string) {
        int n;
        int n2 = statusCodeStrs.length;
        for (n = 0; n < n2 && !string.equals(statusCodeStrs[n]); ++n) {
        }
        this.statusCode = n >= statusCodeStrs.length ? 0 : n;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String string) {
        this.reason = string;
    }

    public Date getRevocationDate() {
        return this.revocationDate;
    }

    public void setRevocationDate(Date date) {
        this.revocationDate = date;
    }

    public String toString() {
        String string = "";
        string = string + this.getStatusCodeString();
        if (this.reason != null && this.reason.length() > 0) {
            string = string + ", reason = " + this.reason;
        }
        if (this.revocationDate != null) {
            string = string + ", revocationDate = " + this.revocationDate;
        }
        return string;
    }
}

