/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1GenericPrimitive;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.CRLDistPointName;
import com.phaos.cert.CRLReason;
import com.phaos.cert.GeneralName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class CRLDistPoint
implements ASN1Object {
    private CRLDistPointName distPointName = null;
    private boolean[] reasons;
    private int reasonsCount;
    private Vector crlIssuer = null;
    private transient ASN1Object contents = null;

    public CRLDistPoint(CRLDistPointName cRLDistPointName) {
        this.distPointName = cRLDistPointName;
    }

    public CRLDistPoint(GeneralName generalName) {
        this.crlIssuer = new Vector();
        this.crlIssuer.addElement(generalName);
    }

    public CRLDistPoint(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void setDistPointName(CRLDistPointName cRLDistPointName) {
        this.distPointName = cRLDistPointName;
        this.update();
    }

    public CRLDistPointName getDistPointName() {
        return this.distPointName;
    }

    public boolean hasReasonFlag(CRLReason cRLReason) {
        int n = cRLReason.getValue();
        return this.reasons != null && n < this.reasons.length ? this.reasons[n] : false;
    }

    public void setReasonFlag(CRLReason cRLReason) {
        this.doSetReasonFlag(cRLReason);
        this.update();
    }

    public void setReasonFlags(CRLReason[] cRLReasonArray) {
        int n = cRLReasonArray.length;
        for (int i = 0; i < n; ++i) {
            this.doSetReasonFlag(cRLReasonArray[i]);
        }
        this.update();
    }

    public void clearReasonFlag(CRLReason cRLReason) {
        int n = cRLReason.getValue();
        if (this.reasons != null && n < this.reasons.length) {
            this.reasons[n] = false;
        }
        this.update();
    }

    public void clearAllReasonFlags() {
        if (this.reasons != null) {
            int n = this.reasons.length;
            for (int i = 0; i < n; ++i) {
                this.reasons[i] = false;
            }
            this.update();
        }
    }

    private void doSetReasonFlag(CRLReason cRLReason) {
        if (this.reasons == null || this.reasons.length < CRLReason.LIST.length) {
            boolean[] blArray = new boolean[CRLReason.LIST.length];
            if (this.reasons != null) {
                System.arraycopy(this.reasons, 0, blArray, 0, this.reasons.length);
            }
            this.reasons = blArray;
        }
        this.reasons[cRLReason.getValue()] = true;
        ++this.reasonsCount;
    }

    public void addCRLIssuerName(GeneralName generalName) {
        if (this.crlIssuer == null) {
            this.crlIssuer = new Vector();
        }
        this.crlIssuer.addElement(generalName);
        this.update();
    }

    public Vector getCRLIssuerNames() {
        return this.crlIssuer;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        Object object;
        this.update();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        if (aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 0) {
            object = new ASN1ConstructedInputStream((InputStream)aSN1SequenceInputStream, 0);
            this.distPointName = new CRLDistPointName((InputStream)object);
            ((ASN1ConstructedInputStream)object).terminate();
        } else {
            this.distPointName = null;
        }
        if (aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 1) {
            int n;
            aSN1SequenceInputStream.setCurrentTag(3);
            object = new ASN1BitString(aSN1SequenceInputStream);
            this.reasons = new boolean[((ASN1BitString)object).bitLength()];
            try {
                for (n = 0; n < this.reasons.length; ++n) {
                    this.reasons[n] = ((ASN1BitString)object).testBit(n);
                    ++this.reasonsCount;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ASN1FormatException("Unknown reasons flag: " + n);
            }
        } else {
            this.reasons = null;
            this.reasonsCount = 0;
        }
        if (aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 2) {
            aSN1SequenceInputStream.setCurrentTag(16);
            this.crlIssuer = new Vector();
            object = new ASN1SequenceInputStream(aSN1SequenceInputStream);
            while (((ASN1ConstructedInputStream)object).hasMoreData()) {
                this.crlIssuer.addElement(new GeneralName((InputStream)object));
            }
            ((ASN1ConstructedInputStream)object).terminate();
        } else {
            this.crlIssuer = null;
        }
        aSN1SequenceInputStream.terminate();
        if (this.distPointName == null && this.reasons == null && this.crlIssuer == null) {
            throw new ASN1FormatException("Empty DRLDistPoint input");
        }
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            if (this.distPointName == null && this.reasons == null && this.crlIssuer == null) {
                throw new IllegalStateException("Invalid CRLDistPoint, all fields missing");
            }
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            if (this.distPointName != null) {
                aSN1Sequence.addElement(new ASN1GenericConstructed(this.distPointName, 0));
            }
            if (this.reasons != null && this.reasonsCount > 0) {
                ASN1BitString aSN1BitString = new ASN1BitString(this.reasons.length);
                for (int i = 0; i < this.reasons.length; ++i) {
                    if (!this.reasons[i]) continue;
                    aSN1BitString.setBit(i);
                }
                aSN1Sequence.addElement(new ASN1GenericPrimitive(aSN1BitString, 1));
            }
            if (this.crlIssuer != null) {
                aSN1Sequence.addElement(new ASN1GenericConstructed(this.crlIssuer, 2));
            }
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1().length();
    }

    private void update() {
        this.contents = null;
    }
}

