/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.GeneralName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AuthorityInfoAccess
implements ASN1Object {
    private Hashtable access = new Hashtable();
    private ASN1Sequence contents = null;

    public AuthorityInfoAccess() {
    }

    public AuthorityInfoAccess(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public void addAccessDescription(ASN1ObjectID aSN1ObjectID, GeneralName generalName) {
        Vector<GeneralName> vector = (Vector<GeneralName>)this.access.get(aSN1ObjectID);
        if (vector == null) {
            vector = new Vector<GeneralName>();
        }
        vector.addElement(generalName);
        this.access.put(aSN1ObjectID, vector);
        this.reset();
    }

    public Enumeration accessMethods() {
        return this.access.keys();
    }

    public Vector getAccessDescriptions(ASN1ObjectID aSN1ObjectID) {
        Vector vector = (Vector)this.access.get(aSN1ObjectID);
        if (vector != null && vector.size() > 0) {
            return vector;
        }
        return null;
    }

    public boolean hasAccessMethod(ASN1ObjectID aSN1ObjectID) {
        return this.getAccessDescriptions(aSN1ObjectID) != null;
    }

    public int methodCount() {
        return this.access.size();
    }

    public String toString() {
        String string = "AuthorityAccessInfo {";
        Enumeration enumeration = this.accessMethods();
        while (enumeration.hasMoreElements()) {
            ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)enumeration.nextElement();
            Vector vector = this.getAccessDescriptions(aSN1ObjectID);
            if (vector == null) continue;
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                string = string + " {" + aSN1ObjectID.toStringCompact() + "," + (GeneralName)enumeration2.nextElement() + "}";
            }
        }
        string = string + " }";
        return string;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.reset();
        this.access = new Hashtable();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        while (aSN1SequenceInputStream.hasMoreData()) {
            ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(aSN1SequenceInputStream);
            ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(aSN1SequenceInputStream2);
            GeneralName generalName = new GeneralName(aSN1SequenceInputStream2);
            this.addAccessDescription(aSN1ObjectID, generalName);
            aSN1SequenceInputStream2.terminate();
        }
        aSN1SequenceInputStream.terminate();
        if (this.access.size() == 0) {
            throw new ASN1FormatException("Sequence must contain at least 1 access description");
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1Sequence().length();
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            Enumeration enumeration = this.accessMethods();
            while (enumeration.hasMoreElements()) {
                ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)enumeration.nextElement();
                Vector vector = this.getAccessDescriptions(aSN1ObjectID);
                if (vector == null) continue;
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
                    aSN1Sequence2.addElement(aSN1ObjectID);
                    aSN1Sequence2.addElement((GeneralName)enumeration2.nextElement());
                    aSN1Sequence.addElement(aSN1Sequence2);
                }
            }
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    private void reset() {
        this.contents = null;
    }
}

