/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.cert.AttributeTypeAndValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AttributeTypeAndValueList
implements ASN1Object,
Cloneable {
    private Vector attributes = new Vector();
    private Hashtable attrMap = new Hashtable();
    private transient ASN1Sequence contents;

    public AttributeTypeAndValueList() {
    }

    public AttributeTypeAndValueList(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public AttributeTypeAndValue addAttribute(AttributeTypeAndValue attributeTypeAndValue) {
        AttributeTypeAndValue attributeTypeAndValue2 = (AttributeTypeAndValue)this.attrMap.get(attributeTypeAndValue.getType());
        if (attributeTypeAndValue2 != null) {
            this.attributes.removeElement(attributeTypeAndValue2);
        }
        this.attributes.addElement(attributeTypeAndValue);
        this.attrMap.put(attributeTypeAndValue.getType(), attributeTypeAndValue);
        this.update();
        return attributeTypeAndValue2;
    }

    public AttributeTypeAndValue addAttribute(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        return this.addAttribute(new AttributeTypeAndValue(aSN1ObjectID, aSN1Object));
    }

    public AttributeTypeAndValue getAttribute(ASN1ObjectID aSN1ObjectID) {
        if (this.hasAttribute(aSN1ObjectID)) {
            return (AttributeTypeAndValue)this.attrMap.get(aSN1ObjectID);
        }
        return null;
    }

    public ASN1Object getAttributeValue(ASN1ObjectID aSN1ObjectID) {
        AttributeTypeAndValue attributeTypeAndValue = this.getAttribute(aSN1ObjectID);
        return attributeTypeAndValue != null ? attributeTypeAndValue.getValue() : null;
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public boolean hasAttribute(ASN1ObjectID aSN1ObjectID) {
        return this.attrMap.containsKey(aSN1ObjectID);
    }

    public Enumeration types() {
        return this.attrMap.keys();
    }

    public Object clone() {
        try {
            AttributeTypeAndValueList attributeTypeAndValueList = (AttributeTypeAndValueList)super.clone();
            attributeTypeAndValueList.attributes = (Vector)this.attributes.clone();
            attributeTypeAndValueList.attrMap = (Hashtable)this.attrMap.clone();
            return attributeTypeAndValueList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        int n = this.attributes.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.attributes.elementAt(i));
            if (i >= n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public Vector elements() {
        return this.attributes;
    }

    public int size() {
        return this.attributes.size();
    }

    public AttributeTypeAndValue elementAt(int n) {
        return (AttributeTypeAndValue)this.attributes.elementAt(n);
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.attributes.removeAllElements();
        this.attrMap.clear();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        while (aSN1SequenceInputStream.hasMoreData()) {
            AttributeTypeAndValue attributeTypeAndValue = new AttributeTypeAndValue(aSN1SequenceInputStream);
            this.attributes.addElement(attributeTypeAndValue);
            this.attrMap.put(attributeTypeAndValue.getType(), attributeTypeAndValue);
        }
        aSN1SequenceInputStream.terminate();
        this.update();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1().length();
    }

    ASN1Sequence toASN1() {
        if (this.contents == null) {
            this.contents = new ASN1Sequence(this.attributes);
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
    }
}

