/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Set;
import com.phaos.ASN1.ASN1SetInputStream;
import com.phaos.cert.Attribute;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AttributeSet
implements ASN1Object,
Cloneable {
    private Hashtable attributes;
    private ASN1Set contents;

    public AttributeSet() {
        this.attributes = new Hashtable();
    }

    public AttributeSet(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public Attribute addAttribute(Attribute attribute) {
        this.update();
        return this.attributes.put(attribute.getType(), attribute);
    }

    public Attribute addAttribute(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        return this.addAttribute(new Attribute(aSN1ObjectID, aSN1Object));
    }

    public Attribute addAttribute(ASN1ObjectID aSN1ObjectID, Vector vector) {
        return this.addAttribute(new Attribute(aSN1ObjectID, vector));
    }

    public Attribute getAttribute(ASN1ObjectID aSN1ObjectID) {
        if (this.hasAttribute(aSN1ObjectID)) {
            return (Attribute)this.attributes.get(aSN1ObjectID);
        }
        return null;
    }

    public void addAttributeValue(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        Attribute attribute = this.getAttribute(aSN1ObjectID);
        if (attribute != null) {
            attribute.addValue(aSN1Object);
        } else {
            this.addAttribute(aSN1ObjectID, aSN1Object);
        }
    }

    public Vector getAttributeValues(ASN1ObjectID aSN1ObjectID) {
        Attribute attribute = this.getAttribute(aSN1ObjectID);
        return attribute != null ? attribute.getValues() : null;
    }

    public int size() {
        return this.attributes.size();
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public boolean hasAttribute(ASN1ObjectID aSN1ObjectID) {
        return this.attributes.containsKey(aSN1ObjectID);
    }

    public Enumeration types() {
        return this.attributes.keys();
    }

    public Object clone() {
        AttributeSet attributeSet = new AttributeSet();
        attributeSet.attributes = (Hashtable)this.attributes.clone();
        return attributeSet;
    }

    public String toString() {
        String string = "{";
        Enumeration enumeration = this.types();
        while (enumeration.hasMoreElements()) {
            string = string + " " + enumeration.nextElement();
            if (!enumeration.hasMoreElements()) continue;
            string = string + ",";
        }
        string = string + " }";
        return string;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.attributes = new Hashtable();
        ASN1SetInputStream aSN1SetInputStream = new ASN1SetInputStream(inputStream);
        while (aSN1SetInputStream.hasMoreData()) {
            Attribute attribute = new Attribute(aSN1SetInputStream);
            this.attributes.put(attribute.getType(), attribute);
        }
        aSN1SetInputStream.terminate();
        this.update();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Set().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1Set().length();
    }

    private void update() {
        this.contents = null;
    }

    public ASN1Set toASN1Set() {
        if (this.contents == null) {
            ASN1Set aSN1Set = new ASN1Set();
            Enumeration enumeration = this.types();
            while (enumeration.hasMoreElements()) {
                aSN1Set.addElement((Attribute)this.attributes.get((ASN1ObjectID)enumeration.nextElement()));
            }
            this.contents = aSN1Set;
        }
        return this.contents;
    }
}

