/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.cert;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1Set;
import com.phaos.ASN1.ASN1SetInputStream;
import com.phaos.ASN1.ASN1Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class Attribute
implements ASN1Object {
    private ASN1ObjectID type;
    private Vector values;
    private ASN1Sequence seq = null;

    public Attribute(ASN1ObjectID aSN1ObjectID) {
        this.type = aSN1ObjectID;
        this.values = new Vector();
    }

    public Attribute(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) {
        this(aSN1ObjectID);
        this.addValue(aSN1Object);
    }

    public Attribute(ASN1ObjectID aSN1ObjectID, Vector vector) {
        this(aSN1ObjectID);
        this.setValues(vector);
    }

    public Attribute(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public ASN1ObjectID getType() {
        return this.type;
    }

    public void addValue(ASN1Object aSN1Object) {
        this.values.addElement(aSN1Object);
        this.reset();
    }

    public void setValues(Vector vector) {
        if (vector.size() == 0) {
            throw new IllegalArgumentException("Attribute value set may not be empty");
        }
        this.values.removeAllElements();
        this.reset();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.values.addElement((ASN1Object)vector.elementAt(i));
        }
    }

    public Enumeration values() {
        return this.values.elements();
    }

    public Vector getValues() {
        return this.values;
    }

    public int size() {
        return this.values.size();
    }

    public String toString() {
        String string = this.type + " : {";
        Enumeration enumeration = this.values();
        while (enumeration.hasMoreElements()) {
            string = string + " " + enumeration.nextElement();
            if (!enumeration.hasMoreElements()) continue;
            string = string + ",";
        }
        string = string + " }";
        return string;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.type = new ASN1ObjectID(aSN1SequenceInputStream);
        this.values = new Vector();
        ASN1SetInputStream aSN1SetInputStream = new ASN1SetInputStream(aSN1SequenceInputStream);
        do {
            this.values.addElement(ASN1Utils.inputASN1Object(aSN1SetInputStream));
        } while (aSN1SequenceInputStream.hasMoreData());
        aSN1SetInputStream.terminate();
        aSN1SequenceInputStream.terminate();
        this.reset();
    }

    private void reset() {
        this.seq = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.seq == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.type);
            aSN1Sequence.addElement(new ASN1Set(this.values()));
            this.seq = aSN1Sequence;
        }
        return this.seq;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1Sequence().length();
    }
}

