/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1Constructed;
import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1SetInputStream;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.ASN1.CachedASN1Object;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;

public class ASN1Set
implements ASN1TaggedObject,
ASN1Constructed {
    public static final int BER = 0;
    public static final int DER_SET = 1;
    public static final int DER_SET_OF = 2;
    private Vector elements = new Vector();
    private int bodyLength = 0;
    private ASN1Header header = null;
    private int encodingType = 2;
    private ASN1Object[] sortedElements = null;

    public ASN1Set() {
    }

    public ASN1Set(ASN1Object aSN1Object) {
        this.addElement(aSN1Object);
    }

    public ASN1Set(Vector vector) {
        this.elements = vector;
        this.bodyLength = 0;
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            this.bodyLength += ((ASN1Object)this.elements.elementAt(i)).length();
        }
    }

    public ASN1Set(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.addElement((ASN1Object)enumeration.nextElement());
        }
    }

    public ASN1Set(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    @Override
    public ASN1Header getHeader() {
        if (this.header == null) {
            this.header = new ASN1Header(17, 0, 1, this.bodyLength);
        }
        return this.header;
    }

    private ASN1Object[] getSortedElements() {
        if (this.sortedElements == null) {
            this.sortedElements = ASN1Set.sortElements(this.elements, this.encodingType);
        }
        return this.sortedElements;
    }

    @Override
    public Vector elements() {
        return this.elements;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public ASN1Object elementAt(int n) {
        return (ASN1Object)this.elements.elementAt(n);
    }

    public ASN1Object firstElement() {
        return (ASN1Object)this.elements.firstElement();
    }

    public ASN1Object lastElement() {
        return (ASN1Object)this.elements.lastElement();
    }

    public void addElement(ASN1Object aSN1Object) {
        this.elements.addElement(aSN1Object);
        this.bodyLength += aSN1Object.length();
        this.header = null;
        this.sortedElements = null;
    }

    public void setEncodingType(int n) {
        this.encodingType = n;
        this.sortedElements = null;
    }

    public int getEncodingType() {
        return this.encodingType;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET {");
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.elements.elementAt(i).toString());
            if (i == this.elements.size() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1SetInputStream aSN1SetInputStream = new ASN1SetInputStream(inputStream);
        this.elements = new Vector();
        this.bodyLength = 0;
        while (aSN1SetInputStream.hasMoreData()) {
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(aSN1SetInputStream);
            this.elements.addElement(aSN1Object);
            this.bodyLength += aSN1Object.length();
        }
        aSN1SetInputStream.terminate();
        this.header = null;
        this.sortedElements = null;
    }

    @Override
    public int length() {
        return this.getHeader().totalLength();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.getHeader().output(outputStream);
        if (this.encodingType == 0) {
            int n = this.elements.size();
            for (int i = 0; i < n; ++i) {
                ((ASN1Object)this.elements.elementAt(i)).output(outputStream);
            }
        } else {
            ASN1Object[] aSN1ObjectArray = this.getSortedElements();
            int n = aSN1ObjectArray.length;
            for (int i = 0; i < n; ++i) {
                aSN1ObjectArray[i].output(outputStream);
            }
        }
    }

    static ASN1Object[] sortElements(Vector vector, int n) {
        ASN1Object[] aSN1ObjectArray = new ASN1Object[vector.size()];
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            aSN1ObjectArray[i] = n == 2 ? new CachedASN1Object((ASN1Object)vector.elementAt(i)) : (ASN1Object)vector.elementAt(i);
        }
        if (n != 0) {
            ASN1Set.qsortElements(aSN1ObjectArray, 0, aSN1ObjectArray.length - 1, n);
        }
        return aSN1ObjectArray;
    }

    private static void qsortElements(ASN1Object[] aSN1ObjectArray, int n, int n2, int n3) {
        if (n2 - n < 1 || n3 == 0) {
            return;
        }
        Random random = new Random();
        int n4 = n + (random.nextInt() & Integer.MAX_VALUE) % (n2 - n + 1);
        ASN1Object aSN1Object = aSN1ObjectArray[n4];
        aSN1ObjectArray[n4] = aSN1ObjectArray[n];
        aSN1ObjectArray[n] = aSN1Object;
        int n5 = n - 1;
        int n6 = n2 + 1;
        while (true) {
            if (ASN1Set.compareElements(aSN1ObjectArray[++n5], aSN1Object, n3) < 0) {
                continue;
            }
            while (ASN1Set.compareElements(aSN1ObjectArray[--n6], aSN1Object, n3) > 0) {
            }
            if (n5 >= n6) break;
            ASN1Object aSN1Object2 = aSN1ObjectArray[n5];
            aSN1ObjectArray[n5] = aSN1ObjectArray[n6];
            aSN1ObjectArray[n6] = aSN1Object2;
        }
        ASN1Set.qsortElements(aSN1ObjectArray, n, n6, n3);
        ASN1Set.qsortElements(aSN1ObjectArray, n6 + 1, n2, n3);
    }

    private static int compareElements(ASN1Object aSN1Object, ASN1Object aSN1Object2, int n) {
        int n2;
        if (n == 1) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Object;
            ASN1TaggedObject aSN1TaggedObject2 = (ASN1TaggedObject)aSN1Object2;
            return aSN1TaggedObject.getHeader().getTag() - aSN1TaggedObject2.getHeader().getTag();
        }
        byte[] byArray = ((CachedASN1Object)aSN1Object).getEncoded();
        byte[] byArray2 = ((CachedASN1Object)aSN1Object2).getEncoded();
        int n3 = Math.min(byArray.length, byArray2.length);
        for (n2 = 0; n2 < n3 && byArray[n2] == byArray2[n2]; ++n2) {
        }
        if (n2 == n3) {
            return byArray.length - byArray2.length;
        }
        return (byArray[n2] & 0xFF) - (byArray2[n2] & 0xFF);
    }
}

