/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1Constructed;
import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class ASN1Sequence
implements ASN1TaggedObject,
ASN1Constructed {
    private Vector elements = new Vector();
    private ASN1Header header = null;
    private int bodyLength;

    public ASN1Sequence() {
    }

    public ASN1Sequence(ASN1Object aSN1Object) {
        this.addElement(aSN1Object);
    }

    public ASN1Sequence(Vector vector) {
        this.elements = vector;
        this.bodyLength = 0;
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            this.bodyLength += ((ASN1Object)this.elements.elementAt(i)).length();
        }
    }

    public ASN1Sequence(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    @Override
    public ASN1Header getHeader() {
        if (this.header == null) {
            this.header = ASN1Sequence.makeHeader(this.bodyLength);
        }
        return this.header;
    }

    @Override
    public Vector elements() {
        return this.elements;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public ASN1Object elementAt(int n) {
        return (ASN1Object)this.elements.elementAt(n);
    }

    public ASN1Object firstElement() {
        return (ASN1Object)this.elements.firstElement();
    }

    public ASN1Object lastElement() {
        return (ASN1Object)this.elements.lastElement();
    }

    public void addElement(ASN1Object aSN1Object) {
        this.elements.addElement(aSN1Object);
        this.bodyLength += aSN1Object.length();
        this.header = null;
    }

    public static ASN1Header makeHeader(int n) {
        return new ASN1Header(16, 0, 1, n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SEQUENCE {");
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.elements.elementAt(i).toString());
            if (i == this.elements.size() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.elements = new Vector();
        this.bodyLength = 0;
        while (aSN1SequenceInputStream.hasMoreData()) {
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(aSN1SequenceInputStream);
            this.elements.addElement(aSN1Object);
            this.bodyLength += aSN1Object.length();
        }
        aSN1SequenceInputStream.terminate();
        this.header = null;
    }

    @Override
    public int length() {
        return this.getHeader().totalLength();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.getHeader().output(outputStream);
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            ((ASN1Object)this.elements.elementAt(i)).output(outputStream);
        }
    }

    public byte[] getEncoded() {
        return Utils.toBytes(this);
    }
}

