/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ASN1OctetString
implements ASN1TaggedObject {
    private ASN1Header header;
    private byte[] value;

    public ASN1OctetString(byte[] byArray) {
        this.initialize(byArray);
    }

    public ASN1OctetString(InputStream inputStream) throws IOException {
        this.initialize(ASN1OctetString.inputValue(inputStream));
    }

    private void initialize(byte[] byArray) {
        this.value = byArray;
        this.header = ASN1OctetString.makeHeader(byArray.length);
    }

    @Override
    public ASN1Header getHeader() {
        return this.header;
    }

    public byte[] getValue() {
        return this.value;
    }

    public static ASN1Header makeHeader(int n) {
        return new ASN1Header(4, 0, 0, n);
    }

    public String toString() {
        return "OCTET STRING " + Utils.toHexString(this.value);
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.initialize(ASN1OctetString.inputValue(inputStream));
    }

    public static byte[] inputValue(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        aSN1Header.checkTag(4);
        if (aSN1Header.getEncodingMethod() == 0) {
            return aSN1Header.readBody(inputStream);
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream(inputStream, aSN1Header);
        while (aSN1ConstructedInputStream.hasMoreData()) {
            unsyncByteArrayOutputStream.write(ASN1OctetString.inputValue(aSN1ConstructedInputStream));
        }
        aSN1ConstructedInputStream.terminate();
        return unsyncByteArrayOutputStream.toByteArray();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.header.output(outputStream);
        outputStream.write(this.value);
    }

    @Override
    public int length() {
        return this.header.totalLength();
    }

    public static void outputValue(OutputStream outputStream, byte[] byArray) throws IOException {
        ASN1OctetString.outputValueWithTag(outputStream, byArray, 4, 0);
    }

    public static void outputValue(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        ASN1OctetString.outputValueWithTag(outputStream, byArray, n, n2, 4, 0);
    }

    public static void outputValueWithTag(OutputStream outputStream, byte[] byArray, int n) throws IOException {
        ASN1OctetString.outputValueWithTag(outputStream, byArray, n, 128);
    }

    public static void outputValueWithTag(OutputStream outputStream, byte[] byArray, int n, int n2, int n3) throws IOException {
        ASN1OctetString.outputValueWithTag(outputStream, byArray, n, n2, n3, 128);
    }

    private static void outputValueWithTag(OutputStream outputStream, byte[] byArray, int n, int n2) throws IOException {
        ASN1OctetString.outputValueWithTag(outputStream, byArray, 0, byArray.length, n, n2);
    }

    private static void outputValueWithTag(OutputStream outputStream, byte[] byArray, int n, int n2, int n3, int n4) throws IOException {
        outputStream.write(n4 + n3);
        ASN1Utils.outputLengthBytes(outputStream, n2);
        outputStream.write(byArray, n, n2);
    }
}

