/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.ASN1;

import com.phaos.ASN1.ASN1ConstructedInputStream;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Header;
import com.phaos.ASN1.ASN1TaggedObject;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Date;

public class ASN1Date
implements ASN1TaggedObject {
    private ASN1Header header;
    private Date value;
    private boolean useGeneralizedTime;

    public ASN1Date() {
        this(new Date());
    }

    public ASN1Date(Date date) {
        this(date, false);
    }

    public ASN1Date(Date date, boolean bl) {
        this.initialize(date, bl);
    }

    public ASN1Date(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    private void initialize(Date date, boolean bl) {
        this.value = date;
        this.useGeneralizedTime = bl;
        this.header = new ASN1Header(bl ? 24 : 23, 0, 0, bl ? 15 : 13);
    }

    @Override
    public ASN1Header getHeader() {
        return this.header;
    }

    public Date getValue() {
        return this.value;
    }

    public void setUseGeneralizedTime(boolean bl) {
        this.useGeneralizedTime = bl;
    }

    public boolean getUseGeneralizedTime() {
        return this.useGeneralizedTime;
    }

    public String toString() {
        return (this.useGeneralizedTime ? "GeneralizedTime " : "UTCTime ") + this.value.toString();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        PushbackInputStream pushbackInputStream = inputStream instanceof PushbackInputStream ? (PushbackInputStream)inputStream : new PushbackInputStream(inputStream);
        int n = Utils.inputByte(pushbackInputStream) & 0xFF;
        pushbackInputStream.unread(n);
        int n2 = ASN1Utils.getTag(n);
        this.initialize(ASN1Date.inputValue(pushbackInputStream), n2 == 24);
    }

    public static Date inputValue(InputStream inputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(inputStream);
        aSN1Header.checkTagClass(0);
        int n = aSN1Header.getTag();
        if (n != 23 && n != 24) {
            throw new ASN1FormatException("Got tag " + n + " instead of " + 23 + " or " + 24 + ".");
        }
        return Utils.parseDate(Utils.fromUTF8(ASN1Date.inputEncValue(inputStream, aSN1Header, 0)), n == 24);
    }

    private static byte[] inputEncValue(InputStream inputStream, ASN1Header aSN1Header, int n) throws IOException {
        if (aSN1Header == null) {
            aSN1Header = new ASN1Header(inputStream);
            aSN1Header.checkTagClass(0);
            aSN1Header.checkTag(n);
        }
        if (aSN1Header.getEncodingMethod() == 0) {
            return aSN1Header.readBody(inputStream);
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        ASN1ConstructedInputStream aSN1ConstructedInputStream = new ASN1ConstructedInputStream(inputStream, aSN1Header);
        while (aSN1ConstructedInputStream.hasMoreData()) {
            unsyncByteArrayOutputStream.write(ASN1Date.inputEncValue(aSN1ConstructedInputStream, null, n));
        }
        aSN1ConstructedInputStream.terminate();
        return unsyncByteArrayOutputStream.toByteArray();
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.header.output(outputStream);
        ASN1Date.outputBody(outputStream, this.value, this.useGeneralizedTime);
    }

    @Override
    public int length() {
        return this.header.totalLength();
    }

    public static void outputValue(OutputStream outputStream, Date date) throws IOException {
        ASN1Date.outputValue(outputStream, date, false);
    }

    public static void outputValue(OutputStream outputStream, Date date, boolean bl) throws IOException {
        ASN1Date.outputValueWithTag(outputStream, date, bl, bl ? 24 : 23, 0);
    }

    public static void outputValueWithTag(OutputStream outputStream, Date date, int n) throws IOException {
        ASN1Date.outputValueWithTag(outputStream, date, false, n);
    }

    public static void outputValueWithTag(OutputStream outputStream, Date date, boolean bl, int n) throws IOException {
        ASN1Date.outputValueWithTag(outputStream, date, bl, n, 128);
    }

    private static void outputValueWithTag(OutputStream outputStream, Date date, boolean bl, int n, int n2) throws IOException {
        outputStream.write(n2 + n);
        outputStream.write(bl ? 15 : 13);
        ASN1Date.outputBody(outputStream, date, bl);
    }

    private static void outputBody(OutputStream outputStream, Date date, boolean bl) throws IOException {
        outputStream.write(Utils.toUTF8(Utils.formatDate(date, bl)));
    }
}

