/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiip.oiipg.OiipgFileSystem;
import oracle.sysman.oii.oiip.oiipg.OiipgPathException;
import oracle.sysman.oii.oiip.oiipg.OiipgPropertyLoader;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;

public class InventoryChecks {
    private InventoryChecks() {
    }

    public static OipcrIResult checkInventoryWritability(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine != null) {
            String sInvLoc = null;
            String sInvPtrLoc = null;
            sInvPtrLoc = System.getProperty("oracle.installer.invPtrLoc", null);
            OiipgPropertyLoader oOpl = new OiipgPropertyLoader();
            try {
                sInvLoc = OiipgPropertyLoader.getLocationFileLoc((String)sInvPtrLoc);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (sInvLoc == null) {
                OiipgBootstrap pg = new OiipgBootstrap();
                sInvLoc = pg.getDefaultLocationFileLoc();
            }
            if (sInvLoc != null) {
                ArrayList oResDetails = new ArrayList();
                InventoryChecks.checkRecursiveWritability(sInvLoc, oResDetails);
                oResult = new OipcrResult(oResDetails);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    private static void checkRecursiveWritability(String sLoc, List oResDetails) {
        if (sLoc != null) {
            OipcrIResult oRes = OipcrResult.FAILED_RESULT;
            try {
                File[] subDirs;
                String sWritableLoc = OiipgFileSystem.checkWritablePath((String)sLoc);
                oRes = OipcrResult.PASSED_RESULT;
                oResDetails.add(new OipcrResultDetails(null, (Object)sLoc, oRes));
                File oFile = new File(sLoc);
                if (oFile.exists() && oFile.isDirectory() && (subDirs = oFile.listFiles()) != null && subDirs.length > 0) {
                    for (int i = 0; i < subDirs.length; ++i) {
                        File curFile = subDirs[i];
                        if (!curFile.isDirectory()) continue;
                        InventoryChecks.checkRecursiveWritability(curFile.getAbsolutePath(), oResDetails);
                    }
                }
            }
            catch (OiipgPathException ope) {
                oResDetails.add(new OipcrResultDetails(null, (Object)sLoc, oRes));
            }
        }
    }
}

